<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;

class AssignTenantApartment extends Command
{
    protected $signature = 'assign:apartments';
    protected $description = 'Assign users to their respective apartments';

    public function handle()
    {
        // Your logic for assigning users to apartments goes here
        // Example logic:
        $roomsUsers = RoomsUser::all();

        foreach ($roomsUsers as $roomsUser) {
            $userApartment = new UserApartment([
                'user_id' => $roomsUser->user_id,
                'apartment_id' => $roomsUser->room->apartment_id,
            ]);
            $userApartment->save();
        }

        $this->info('Users assigned to apartments successfully.');
    }
}
