<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\User;

class UpdateUserRoles extends Command
{
    protected $signature = 'update:user-roles';
    protected $description = 'Update user roles based on certain conditions';

    public function handle()
    {
        // Your logic to update user roles
        // Example: Update users with rooms to have the 'tenant' role

        $usersWithRooms = User::whereHas('rooms')->get();
        foreach ($usersWithRooms as $user) {
            $user->assignRole('tenant');
        }

        // Example: Update users without rooms and no other role to have no role or 'guest' role
        $usersWithoutRooms = User::doesntHave('rooms')->whereDoesntHave('roles')->get();
        foreach ($usersWithoutRooms as $user) {
            $user->removeRole('tenant'); // Remove 'tenant' role if previously assigned
            $user->assignRole('guest');  // Assign 'guest' role
        }

        $this->info('User roles updated successfully.');
    }
}
