<?php

namespace App\Console;



use App\Models\Invoice;
use Illuminate\Console\Scheduling\Schedule;
use App\Console\Commands\GenerateMonthlyInvoices;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;

class Kernel extends ConsoleKernel
{
    protected $commands = [
        // ...
        \App\Console\Commands\GenerateMonthlyInvoices::class,
        \App\Console\Commands\UpdateUserRoles::class,
    ];
    /**
     * Define the application's command schedule.
     *
     * @param  \Illuminate\Console\Scheduling\Schedule  $schedule
     * @return void
     */
    protected function schedule(Schedule $schedule)
    {

        \Log::info('Scheduled task started');
            // ... your task logic ...
              // $schedule->command('inspire')->hourly();
        $schedule->command('invoices:generate')->everyMinute();
        \Log::info('Scheduled task completed');

        // Run the GenerateApartmentExpensesInvoices command daily at midnight
        $schedule->command('invoices:generate-apartment-expenses')->monthly();
        \Log::info('Scheduled task invoices:generate-apartment-expenses completed');

        $schedule->call(function () {
            // Logic to check and update payment statuses
            $invoices = Invoice::all();
            foreach ($invoices as $invoice) {
                $balance = $invoice->total_amount - $invoice->amount_paid;

                if ($balance == 0) {
                    $invoice->payment_status = 'paid';
                } elseif ($balance > 0) {
                    $invoice->payment_status = 'partial';
                } else {
                    $invoice->payment_status = 'unpaid';
                }

                $invoice->save();
            }
        })->daily(); // Run the task daily, you can adjust the schedule as needed

         // Schedule the command to run daily, adjust the frequency as needed
    $schedule->command('update:user-roles')->daily();
    }

    /**
     * Register the commands for the application.
     *
     * @return void
     */
    protected function commands()
    {
        $this->load(__DIR__.'/Commands');

        require base_path('routes/console.php');
    }


}
