<?php

namespace App\Events;

use Illuminate\Broadcasting\Channel;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Broadcasting\PresenceChannel;
use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;
use App\Models\User;

class UserActivityUpdated implements ShouldBroadcast
{
    use SerializesModels;

    public $onlineAdmins;

    public function __construct()
    {
        // Get online admin users with their data
        $this->onlineAdmins = User::where('is_admin', 1)
            ->where('is_online', true)
            ->select('name', 'avatar', 'last_active')
            ->get();
    }

    public function broadcastOn()
    {
        return new Channel('admin-activity');
    }
}
