<?php

namespace App\Http\Controllers;

use Carbon\Carbon;
use Illuminate\Http\Request;

class ApartmentChartsController extends Controller
{
    //
    use ApartmentLandlordViewController;
        public function showApartmentRooms(Request $request, $apartmentId) {
            // Use the accessApartment method from the trait
            $data = $this->accessApartment($apartmentId);
            // Access the variables from the compact statement
            $user = $data['user'];
            $apartment = $data['apartment'];
            $apartments = $data['apartments'];
            // Use Carbon to get the current month
    $currentMonth = Carbon::now()->month;
         // Retrieve rooms with room_number from the pivot table
         $rooms = $apartment->rooms()->with(['invoices' => function ($query) use ($currentMonth) {
            $query->whereMonth('due_date', $currentMonth);
        }])->withPivot('room_number')->get();

        $roomData = [];
        $paymentData = [];

        foreach ($rooms as $room) {
            $paymentStatus = 'Unpaid'; // Default status if no invoices are found

            // Check for invoices and update payment status
            if ($room->invoices->isNotEmpty()) {
                foreach ($room->invoices as $invoice) {
                    $paymentStatus = $this->getPaymentStatus($invoice);
                    // If at least one invoice is found, update payment status and break the loop
                    if ($paymentStatus !== 'Unpaid') {
                        break;
                    }
                }
            }

            $roomData[] = [
                'name' => $room->pivot->room_number,
                'status' => $room->status,
                'payment_status' => $paymentStatus,
            ];
            $paymentData[] = [
                'room_name' => $room->pivot->room_number,
                'payment_status' => $paymentStatus,
                // Add more payment-related data if needed
            ];
        }

        // Log or print $roomData to debug
        // dd($roomData);

        return view('landlord.apartments.charts.rooms', compact('apartment', 'apartments', 'roomData','paymentData'));
    }

        private function getPaymentStatus($invoice)
        {
            if ($invoice->status == 'paid') {
                return 'Paid';
            } elseif ($invoice->status == 'partial') {
                return 'Partially Paid';
            } else {
                return 'Unpaid';
            }
        }

}
