<?php

namespace App\Http\Controllers;

use App\Models\Apartments;
use App\Models\FixedExpense;
use Illuminate\Http\Request;
use App\Models\VaryingExpense;

class ApartmentExpensesController extends Controller
{
    //
    use ApartmentLandlordViewController;
    public function show($apartmentId){
 // Use the accessApartment method from the trait
 $data = $this->accessApartment($apartmentId);
 // Access the variables from the compact statement
$user = $data['user'];
$apartment = $data['apartment'];
$apartments = $data['apartments'];

$fixedExpenses = FixedExpense::where('apartment_id', $apartment->id)->get();

        return view('landlord.apartments.expenses', compact('apartment', 'fixedExpenses'));
    }
    public function create($apartmentId)
    {
        $data = $this->accessApartment($apartmentId);
 // Access the variables from the compact statement
$user = $data['user'];
$apartment = $data['apartment'];
$apartments = $data['apartments'];
        return view('expenses.create', compact('apartment'));
    }

    // Create Fixed Expense
    public function createFixedExpense(Apartments $apartment)
    {
        return view('landlord.apartments.create-fixed-expense', compact('apartment'));
    }

    // Store Fixed Expense
    public function storeFixedExpense(Request $request, Apartments $apartment)
{
    try {
        $request->validate([
            'name' => 'required',
            'amount' => 'required|numeric',
            'frequency' => 'required',
            'start_date' => 'required|date',
            'status' => 'required',
        ]);

        $expense = new FixedExpense([
            'name' => $request->input('name'),
            'amount' => $request->input('amount'),
            'frequency' => $request->input('frequency'),
            'start_date' => $request->input('start_date'),
            'status' => $request->input('status'),
        ]);

        $apartment->fixedExpenses()->save($expense);

        return response()->json(['success' => true, 'expense' => $expense]);
    } catch (\Exception $e) {
        // Log the exception for debugging purposes
        \Log::error($e);

        // Return a JSON response indicating an error
        return response()->json(['success' => false, 'error' => 'An unknown error occurred.']);
    }
}
public function getFixedExpenses(Request $request, Apartments $apartment)
{
    try {
        $data = $this->accessApartment($apartment);
        $apartment = $data['apartment'];
    $fixedExpenses = $apartment->fixedExpenses;
    \DB::listen(function ($query) {
        \Log::info($query->sql, $query->bindings);
    });
    return view('landlord.apartments.expenses', compact('fixedExpenses','apartment'));
} catch (\Exception $e) {
    \Log::error('Error in getFixedExpenses: ' . $e->getMessage());
    return response()->json(['error' => 'Internal Server Error'], 500);
}
}
    // Destroy Fixed Expense
    public function destroyFixedExpense(Apartments $apartment, FixedExpense $expense)
    {
        $expense->delete();

        return response()->json(['success' => true]);
    }

    // Create Varying Expense
    public function createVaryingExpense(Apartments $apartment)
    {
        return view('apartment-expenses.create-varying-expense', compact('apartment'));
    }

    // Store Varying Expense
    public function storeVaryingExpense(Request $request, Apartments $apartment)
    {
        $request->validate([
            'amount' => 'required|numeric',
            'description' => 'required',
            'date' => 'required|date',
            'status' => 'required',
        ]);

        $expense = new VaryingExpense([
            'amount' => $request->input('amount'),
            'description' => $request->input('description'),
            'date' => $request->input('date'),
            'status' => $request->input('status'),
        ]);

        $apartment->varyingExpenses()->save($expense);

        return response()->json(['success' => true, 'expense' => $expense]);
    }

    // Destroy Varying Expense
    public function destroyVaryingExpense(Apartments $apartment, VaryingExpense $expense)
    {
        $expense->delete();

        return response()->json(['success' => true]);
    }
}


