<?php

namespace App\Http\Controllers;

use App\Models\Apartments;
use Illuminate\Http\Request;

class AvatarsController extends Controller
{
    //
    // Storing user avatar
    public function uploadAvatar(Request $request)
    {
        $user = auth()->user();

        // Validate the uploaded file
        $request->validate([
            'avatar' => 'image|mimes:jpeg,png,jpg,gif|max:2048', // Adjust as needed
        ]);

        // Store the uploaded image
        $avatarPath = $request->file('avatar')->store('avatars', 'public');

        // Save the file path in the users table
        $user->update(['avatar' => $avatarPath]);

        return redirect()->back()->with('success', 'Avatar uploaded successfully.');
    }
// Storing apartment avatar
public function uploadApartmentAvatar(Request $request, $apartmentId)
{
    $apartment = Apartments::findOrFail($apartmentId);

    // Validate and store the uploaded image
    $filename = $request->file('avatar')->store('avatars', 'public');

    // Save the file path in the apartments table
    $apartment->update(['avatar' => $filename]);

    return redirect()->back()->with('success', 'Apartment avatar uploaded successfully.');
}

}
