<?php

namespace App\Http\Controllers;

use App\Models\Apartments;
use Illuminate\Http\Request;
use App\Models\EmailTemplate;
use Illuminate\Support\Facades\Log;
use Illuminate\Validation\ValidationException;

class EmailTemplateController extends Controller
{
    //
    public function index()
    {
        \DB::enableQueryLog();


        $templates = EmailTemplate::all();
        //dd(\DB::getQueryLog());
        //dd($templates);


        return view('admin.email-templates.index', compact('templates'));
    }

    public function create()
    {
        return view('admin.email-templates.create');
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required',
            'subject' => 'required',
            'body' => 'required',
        ]);

        EmailTemplate::create($request->all());

        return redirect()->route('admin.email-templates.index')->with('success', 'Email template created successfully');
    }

    public function edit(EmailTemplate $emailTemplate)
    {
        return view('admin.email-templates.edit', compact('emailTemplate'));
    }

    public function update(Request $request, EmailTemplate $emailTemplate)
    {
        $request->validate([
            'name' => 'required',
            'subject' => 'required',
            'body' => 'required',
        ]);

        $emailTemplate->update($request->all());

        return redirect()->route('email-templates.edit')->with('success', 'Email template updated successfully');
    }

    public function destroy(EmailTemplate $emailTemplate)
    {
        $emailTemplate->delete();

        return redirect()->route('email-templates.index')->with('success', 'Email template deleted successfully');
    }

    public function showAttachTemplateForm(Apartments $apartment)
    {
        $templates = EmailTemplate::all();
        $apartments = Apartments::all();
        //dd($apartments);

        return view('admin.email-templates.attach-to-apartment', compact('apartments', 'templates'));
    }

    public function attachTemplate(Request $request)
    { try {
        $templateIds = $request->input('templates');
        $apartmentIds = $request->input('apartments');

        // Validate if at least one template is selected
        if (empty($templateIds)) {
            throw ValidationException::withMessages(['templates' => 'Please select at least one template.']);
        }

        // Retrieve existing template attachments for the selected apartments
        $existingAttachments = Apartments::whereIn('id', $apartmentIds)->with('emailTemplates')->get();

       // Attach the selected templates to the apartments
foreach ($apartmentIds as $apartmentId) {
    $apartment = $existingAttachments->where('id', $apartmentId)->first();

    if ($apartment) {
        $attachedTemplatesIds = $apartment->emailTemplates->pluck('id')->toArray();

        // Filter out templates that are already attached
        $templatesToAttach = array_diff($templateIds, $attachedTemplatesIds);

        if (!empty($templatesToAttach)) {
            $apartment->emailTemplates()->sync($templatesToAttach, false); // Use sync with false parameter

            // Log the attachment action
            Log::info('Templates attached to apartment', ['apartment_id' => $apartmentId, 'template_ids' => $templatesToAttach]);
            // Retrieve existing template attachments for the selected apartments
$existingAttachments = Apartments::whereIn('id', $apartmentIds)->with('emailTemplates')->get();

// Log retrieved apartments for debugging
Log::info('Retrieved Apartments', $existingAttachments->toArray());
        }
    } else {
        // Log error for invalid apartment ID
        Log::error('Apartment not found', ['apartment_id' => $apartmentId]);
    }
}


        return redirect()->back()->with('success', 'Templates attached successfully to selected apartments.');
    } catch (\Exception $e) {
        return redirect()->back()->with('error', $e->getMessage());
    }
}
public function showTemplatesForApartment($apartmentId)
{
    $apartment = Apartments::findOrFail($apartmentId);
    $attachedTemplates = $apartment->emailTemplates()->get();

    return view('your.view', compact('apartment', 'attachedTemplates'));
}
}
