<?php

namespace App\Http\Controllers;

use Carbon\Carbon;
use App\Models\User;
use App\Models\Invoice;
use App\Models\Apartments;

use Illuminate\Http\Request;
use App\Models\EmailTemplate;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Pagination\LengthAwarePaginator;
use App\Http\Controllers\ApartmentLandlordViewController;

class InvoiceController extends Controller
{
    //
    use ApartmentLandlordViewController;
    public function create()
{
    // Return a view for creating a new invoice
    return view('invoices.create');
}

public function store(Request $request)
{
    // Validate and store the invoice data
    // Associate the invoice with a room (room_id)
    // Redirect to the room or invoice list view with a success message
}

public function edit(Invoice $invoice)
{
    // Return a view for editing the invoice
    return view('invoices.edit', compact('invoice'));
}

public function update(Request $request, Invoice $invoice)
{
    // Validate and update the invoice data
    // Redirect to the room or invoice list view with a success message
}
public function showInvoice($id)
{
     // Check if the user is authorized to view the invoice
     //$this->authorize('view', Invoice::class);
// Retrieve the authenticated user
$user = Auth::user();
    // Fetch the invoice belonging to the user
    $invoice = $user->invoices()->findOrFail($id);
     // Retrieve the apartment associated with the invoice
     $apartment = $invoice->rooms->apartments->first(); ; // Assuming the invoice belongs to a room
    if (!$invoice) {
        // Handle the case where the invoice is not found
        return redirect()->route('home')->with('error', 'Invoice not found.');
    }
    // Retrieve the image path from the apartment
    $imagePath = $apartment->image; // Assuming 'image' is the column storing the image path

    return view('tenant.invoices.invoice', compact('invoice', 'apartment','imagePath'));
}
public function showUserInvoices(){
    $user = auth()->user();
    // Retrieve the tenant's rooms
 $rooms = auth()->user()->rooms;
 // Load user's invoices with associated rooms
 $invoices = $user->invoices()->with('rooms')->get();
    return view('tenant.invoices.invoices',compact('rooms','invoices'));
}
public function landlordShowApartmentInvoices(request $request, $apartmentId)

{
    // Use the accessApartment method from the trait
    $data = $this->accessApartment($apartmentId);
    // Access the variables from the compact statement
  $user = $data['user'];
  $apartment = $data['apartment'];
  $apartments = $data['apartments'];

    $paymentStatus = $request->input('status', 'all'); // Default to 'all' if no status is provided
    // Step 1: Check if the authenticated user is a landlord
                if (auth()->user()->hasRole('landlord')) {

                                // Retrieve the selected apartment
                        // $apartment = Apartments::findOrFail($apartmentId);
                        // Check if the user is associated with the requested apartment
                        $apartment = $user->apartments()->find($apartmentId);

                        // Retrieve the list of apartments associated with the user
    $apartments = $user->apartments()->get(); // Assuming your relationship is defined correctly

                        if ($apartment) {
                             // Retrieve property data for the apartment
        $properties = $apartment->properties;

        //   // Retrieve invoices associated with rooms in the apartment using the pivot table
        $apartmentInvoices = Invoice::whereHas('rooms.apartments', function ($query) use ($apartment) {
            $query->where('apartments.id', $apartment->id);
        })->get();
                                        // Fetch all users
     $users = User::with('invoices')->get();

    $currentPage = LengthAwarePaginator::resolveCurrentPage();
    $perPage = 15; // Adjust the number of items per page as needed
    $currentPageItems = $apartmentInvoices->slice(($currentPage - 1) * $perPage, $perPage)->all();

    $apartmentInvoices = new LengthAwarePaginator($currentPageItems, count($apartmentInvoices), $perPage);

    $apartmentInvoices->setPath($request->url());

    $apartmentInvoices->each(function ($invoice) {
        $invoice->payments = json_decode($invoice->payments, true);
        $invoice->max_payment_date = collect($invoice->payments)->max('payment_date');
    });
     // Calculate compounded balances for each user
     $userCompoundedBalances = [];

     foreach ($users as $user) {
         $userCompoundedBalances[$user->id] = $this->calculateCompoundedBalances($user);
     }


        // // Filter i
    //            // Example: Fetch current month's invoices
    // $currentMonthInvoices = $apartment->invoices()
    // ->whereMonth('invoice_date', now()->month)
    // ->get();


                            // Debugging: Dump and die to check the retrieved data
                            //dd($apartmentInvoices);
                           //dd($apartments);

                                return view('landlord.apartment-invoices', compact('userCompoundedBalances','apartmentInvoices','users','user','paymentStatus','apartment','apartments'))
                                ->with('currentMonthInvoices');
                            } else {
                                // The user is not associated with the requested apartment
                                // Redirect to custom 403 page for unauthorized apartment access
                                return abort(403, 'Unauthorized action. You do not have access to this apartment.');
                            }
                        } else {
                            // The user does not have the role of a landlord
                            // Redirect to custom 403 page for users without the landlord role
                            return abort(403, 'Unauthorized action. Only landlords can access this page.');
                        }
                        }

                        public function apartmentRecentPayments(Request $request, $apartmentId)
                        {
                            $apartmentData = $this->getApartmentRecentPayments($request, $apartmentId);

                            if ($apartmentData === null) {
                                return redirect()->route('home')->with('error', 'Unauthorized or Apartment not found.');
                            }

                            extract($apartmentData); // Extract the variables from the returned array

                            // Return the view with the apartment recent payments data and other apartment-related data
                            return view('landlord.apartments.apartment-recent-payments', compact('apartmentRecentPayments', 'apartments', 'apartment'));
                        }

                        public function deleteByDate(Request $request, $apartmentId)
                        {
                            $dateAndTime = $request->input('date_and_time');

                            // Convert the date and time string to a Carbon instance
                            $dateTime = \Carbon\Carbon::parse($dateAndTime);

                            // Extract date and time separately
                            $date = $dateTime->toDateString();
                            $time = $dateTime->toTimeString();

                            //dd($date);
                            // Use the accessApartment method from the trait
                            $data = $this->accessApartment($apartmentId);
                            // Access the variables from the compact statement
                            $user = $data['user'];
                            $apartment = $data['apartment'];
                            $apartments = $data['apartments'];

                            // Step 1: Check if the authenticated user is a landlord
                            if (auth()->user()->hasRole('landlord')) {
                                // Check if the user is associated with the requested apartment
                                $apartment = $user->apartments()->find($apartmentId);

                                if ($apartment) {
                                    // Retrieve invoices associated with rooms in the apartment using the pivot table
                                     // Use both date and time filters in the query
                                    $apartmentInvoices = Invoice::whereHas('rooms.apartments', function ($query) use ($apartmentId) {
                                        $query->where('apartments.id', $apartmentId);
                                    })
                                    ->whereDate('created_at', $date)
                                    ->whereTime('created_at', '>=', $time) // Use '>=' to include the specified time and later times
                                    ->get();


                                    // Delete invoices generated on the specified date
                                    foreach ($apartmentInvoices as $invoice) {
                                        $invoice->delete();
                                    }

                                    return redirect()->back()->with('success', 'Invoices generated on ' . $date .' at' .$time.' have been deleted.');
                                } else {
                                    return redirect()->back()->with('error', 'You are not authorized to delete invoices for this apartment.');
                                }
                            } else {
                                return redirect()->back()->with('error', 'You are not authorized to delete invoices.');
                            }
                        }


                        // Method to retrieve apartment recent payments
                        protected function getApartmentRecentPayments(Request $request, $apartmentId)
                        {
                            // Use the accessApartment method from the trait
                            $data = $this->accessApartment($apartmentId);

                            // Access the variables from the compact statement
                            $user = $data['user'];
                            $apartment = $data['apartment'];
                            $apartments = $data['apartments'];

                            $paymentStatus = $request->input('status', 'all'); // Default to 'all' if no status is provided

                            // Step 1: Check if the authenticated user is a landlord
                            if (auth()->user()->hasRole('landlord')) {

                                // Check if the user is associated with the requested apartment
                                $apartment = $user->apartments()->find($apartmentId);

                                if ($apartment) {
                                    // Retrieve property data for the apartment
                                    $properties = $apartment->properties;

                                    // Retrieve invoices associated with rooms in the apartment using the pivot table
                                    $apartmentInvoices = Invoice::whereHas('rooms', function ($query) use ($apartment) {
                                        $query->whereHas('apartments', function ($subQuery) use ($apartment) {
                                            $subQuery->where('apartments.id', $apartment->id);
                                        });
                                    })->get();

                                    // Fetch all users
                                    $users = User::with('invoices')->get();

                                    $filteredInvoices = $apartmentInvoices->filter(function ($invoice) {
                                        return !is_null($invoice->payments);
                                    })->sortByDesc('due_date');

                                    $currentPage = LengthAwarePaginator::resolveCurrentPage();
                                    $perPage = 10; // Adjust the number of items per page as needed
                                    $currentPageItems = $filteredInvoices->slice(($currentPage - 1) * $perPage, $perPage)->all();

                                    $apartmentRecentPayments = new LengthAwarePaginator($currentPageItems, count($filteredInvoices), $perPage);

                                    $apartmentRecentPayments->setPath($request->url());

                                    $apartmentRecentPayments->each(function ($invoice) {
                                        $invoice->payments = json_decode($invoice->payments, true);
                                        $invoice->max_payment_date = collect($invoice->payments)->max('payment_date');
                                    });


    return [
        'apartmentRecentPayments' => $apartmentRecentPayments,
        'apartments' => $data['apartments'],
        'apartment' => $data['apartment']
    ];
                                }
                            }

                            // If the user is not authorized or the apartment is not found, return null
                            return null;
                        }

                        public function handlePaymentsAction(Request $request, $apartmentId) {
                                                        // Retrieve the apartment ID from the request
                                $apartmentId = $request->input('apartment_id'); // Assuming the apartment ID is passed in the request

                                // Ensure the apartment ID is not null
                                if (!$apartmentId) {
                                    return redirect()->route('home')->with('error', 'Apartment ID is missing.');
                                }

                                // Retrieve apartment recent payments by calling the method with the required arguments
                                $apartmentRecentPayments = $this->getApartmentRecentPayments($request, $apartmentId);

                                // If apartment recent payments are not found or unauthorized, redirect
                                if ($apartmentRecentPayments === null) {
                                    return redirect()->route('home')->with('error', 'Unauthorized or Apartment not found.');
                                }
                            // Process the payment action
                            $selectedPayments = $request->input('selected_payments', []);
                            $action = $request->input('action');
                                                    switch ($action) {
                                case 'remove':
                                    foreach ($selectedPayments as $paymentId) {
                                        // Iterate through selected payment IDs and remove them from the invoices
                                        foreach ($apartmentRecentPayments as $invoice) {
                                            if (isset($invoice->payments) && is_iterable($invoice->payments)) {
                                                foreach ($invoice->payments as $index => $payment) {
                                                    if ($payment['payment_id'] == $paymentId) {
                                                        unset($invoice->payments[$index]);
                                                    }
                                                }
                                            }
                                        }
                                    }
                                    // After removal, you may want to save the updated data or perform any necessary actions
                                    break;

                                    case 'edit':
                                        // Assuming you have a form for editing payments with new amounts
                                        foreach ($selectedPayments as $paymentId) {
                                            $newAmount = $request->input("payment_$paymentId"); // Assuming input names are like "payment_paymentId"
                                            // Find and update the selected payment with the new amount
                                            foreach ($apartmentRecentPayments as $invoice) {
                                                if (isset($invoice->payments) && is_iterable($invoice->payments)) {
                                                    foreach ($invoice->payments as $index => $payment) {
                                                        if ($payment['payment_id'] == $paymentId) {
                                                            $invoice->payments[$index]['payment_amount'] = $newAmount;
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                        // After editing, you may want to save the updated data or perform any necessary actions
                                        break;

                                        case 'transfer':
                                            // Assuming you have a form for selecting destination invoices
                                            $destinationInvoice = $request->input('destination_invoice');
                                            foreach ($selectedPayments as $paymentId) {
                                                // Find the payment to be transferred
                                                foreach ($apartmentRecentPayments as $invoice) {
                                                    if (isset($invoice->payments) && is_iterable($invoice->payments)) {
                                                        foreach ($invoice->payments as $index => $payment) {
                                                            if ($payment['payment_id'] == $paymentId) {
                                                                // Remove the payment from the current invoice
                                                                unset($invoice->payments[$index]);
                                                                // Add the payment to the destination invoice
                                                                foreach ($apartmentRecentPayments as $destInvoice) {
                                                                    if ($destInvoice->invoice_number == $destinationInvoice) {
                                                                        $destInvoice->payments[] = $payment;
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                            // After transferring, you may want to save the updated data or perform any necessary actions
                                            break;
                                default:
                                    // Handle invalid action
                                    break;
                            }

                            // Redirect or return response as needed
                        }
                        public function landlordShowApartmentThisMonthInvoice(request $request, $apartmentId)
    {

                                    // Use the accessApartment method from the trait
                                    $data = $this->accessApartment($apartmentId);
                                    // Access the variables from the compact statement
                                $user = $data['user'];
                                $apartment = $data['apartment'];
                                $apartments = $data['apartments'];

                                    $paymentStatus = $request->input('status', 'all'); // Default to 'all' if no status is provided
                                    // Step 1: Check if the authenticated user is a landlord
                                                if (auth()->user()->hasRole('landlord')) {

                                                                // Retrieve the selected apartment
                                                        // $apartment = Apartments::findOrFail($apartmentId);
                                                        // Check if the user is associated with the requested apartment
                                                        $apartment = $user->apartments()->find($apartmentId);

                                                        // Retrieve the list of apartments associated with the user
                                    $apartments = $user->apartments()->get(); // Assuming your relationship is defined correctly

                                                        if ($apartment) {
                                                            // Get the current year and month
                                    $currentYear = now()->year;
                                    $currentMonth = now()->month;

                                    // Calculate the start and end dates for the current month
                                    $startDate = Carbon::create($currentYear, $currentMonth, 1)->startOfMonth();
                                    $endDate = Carbon::create($currentYear, $currentMonth, 1)->endOfMonth();

                                    // // Query invoices with due dates in the current month
                                    // $currentMonthInvoices = Invoice::whereHas('rooms', function ($query) use ($apartment) {
                                    //     $query->whereHas('apartments', function ($subQuery) use ($apartment) {
                                    //         $subQuery->where('apartments.id', $apartment->id);
                                    //     });
                                    // })->get();

                                     // Filter invoices for the current month and rooms belonging to the apartment
                                     $currentMonthInvoices = Invoice::whereHas('rooms', function ($query) use ($apartment) {
                                        $query->whereHas('apartments', function ($subQuery) use ($apartment) {
                                            $subQuery->where('apartment_id', $apartment->id);
                                        });
                                    })->whereMonth('due_date', now()->month)->get();



                                    // Update payment status to "Paid" if balance is zero
                                    foreach ($currentMonthInvoices as $invoice) {
                                        if ($invoice->balance == 0) {
                                            $invoice->payment_status = 'Paid';
                                        }
                                    }

                                    // Calculate the total amount paid and total amount unpaid for the current month
                                    $totalAmountPaid = $currentMonthInvoices->sum('paid_amount');
                                    $totalAmountUnpaid = $currentMonthInvoices->sum('total_amount') - $totalAmountPaid;

                                    // Create a monthly report entry
                                    $thisMonthReport = [
                                        'month' => $startDate ? $startDate->format('F Y') : 'N/A',// Format as "Month Year"
                                        'total_amount_paid' => $totalAmountPaid,
                                        'total_amount_unpaid' => $totalAmountUnpaid,
                                    ];
                                    // Calculate totals (if necessary)
                                    $totalInvoiceAmount = $currentMonthInvoices->sum('total_amount');
                                    $totalBalance = $currentMonthInvoices->sum('balance');
                                    $totalAmountPaid = $currentMonthInvoices->sum('amount_paid');
                                    $totalAmountUnpaid = $currentMonthInvoices->sum('amount_unpaid');
                                    //  // Fetch all users
                                    //  $users = User::with('invoices')->get();

                                    //  // Calculate compounded balances for each user
                                    //  $userCompoundedBalances = [];

                                    //  foreach ($users as $user) {
                                    //      $userCompoundedBalances[$user->id] = $this->calculateCompoundedBalances($user);
                                    //  }

                                    //                         // Example: Fetch current month's invoices
                                    // $currentMonthInvoices = $apartment->invoices()
                                    // ->whereMonth('invoice_date', now()->month)
                                    // ->get();
                                // Retrieve users with rooms belonging to the apartment
                                // $usersWithRooms = $apartment->users()
                                //     ->wherePivot('role', 'tenant')
                                //     ->get();

                                // // Calculate compounded balances for each user
                                // $usersWithBalances = $usersWithRooms->map(function ($user) {
                                //     // Assuming you have a method to calculate the compounded balance for a user
                                //     $compoundedBalance = $user->calculateCompoundedBalances();

                                //     // Add the compounded balance to the user object
                                //     $user->compoundedBalance = $compoundedBalance;

                                //     return $user;
                                 // Fetch all apartment tenants
                                 $users = User::whereHas('invoices', function ($query) use ($apartment) {
                                    $query->whereHas('rooms', function ($subQuery) use ($apartment) {
                                        $subQuery->whereHas('apartments', function ($apartmentQuery) use ($apartment) {
                                            $apartmentQuery->where('apartments.id', $apartment->id);
                                        });
                                    });
                                })->get();


     // Calculate compounded balances for each user
     $userCompoundedBalances = [];

     foreach ($users as $user) {
         $userCompoundedBalances[$user->id] = $this->calculateCompoundedBalances($user);
     }
     $emailTemplate = EmailTemplate::find(3); // Fetch the email template from the database
                                        return view('landlord.apartment-this-month-invoices', compact('currentMonthInvoices', 'emailTemplate', 'apartments','apartment','paymentStatus',
                                        'userCompoundedBalances','totalBalance',  'totalInvoiceAmount', 'totalAmountPaid','users', 'totalAmountUnpaid', 'thisMonthReport'));
                                    }
                }
            }
    private function calculateCompoundedBalances($user)
            {
                $compoundedBalances = [];

                // Load invoices for the user with due dates in the current month
                $currentMonth = Carbon::now();
                $invoices = $user->invoices()->whereYear('due_date', $currentMonth->year)
                    ->whereMonth('due_date', $currentMonth->month)
                    ->get();

                foreach ($invoices as $invoice) {
                    $roomBalance = 0;

                    // Query previous invoices for the same room and earlier due dates
                    $previousInvoices = $user->invoices()
                        ->where('room_id', $invoice->room_id)
                        ->where('due_date', '<', $invoice->due_date)
                        ->orderBy('due_date', 'asc')
                        ->get();

                    // Calculate the compounded balance for this invoice
                    $roomBalance = $invoice->balance;
                    foreach ($previousInvoices as $previousInvoice) {
                        $roomBalance += $previousInvoice->balance;
                    }

                    $compoundedBalances[] = [
                        'invoice' => $invoice,
                        'compounded_balance' => $roomBalance,
                    ];
                }

                return $compoundedBalances;
            }



            //user invoices

            public function landlordShowUserApartmentInvoices(request $request, $apartmentId, $userId){

                // Access the apartment and user information
                $data = $this->accessApartment($apartmentId);
                $user = $data['user'];
                $apartment = $data['apartment'];

                // Ensure the tenant belongs to the specified apartment
                $tenant = User::where('id', $userId)
                    ->whereHas('apartments', function ($query) use ($apartment) {
                        $query->where('apartments.id', $apartment->id);
                    })
                    ->first();

                // Ensure the user exists and belongs to the specified apartment
                if (!$tenant) {
                    return response()->json(['success' => false, 'message' => 'Invalid user or user does not belong to the specified apartment']);
                }

                // Retrieve invoices associated with the tenant for the specified apartment
                $tenantInvoices = $tenant->invoices()
    ->whereHas('room', function ($query) use ($apartment) {
        $query->whereHas('apartments', function ($subQuery) use ($apartment) {
            $subQuery->where('apartments.id', $apartment->id);
        });
    })
    ->get();


    // Paginate the invoices if needed
    $perPage = 15;
    $currentPage = LengthAwarePaginator::resolveCurrentPage();
    $currentPageItems = $tenantInvoices->slice(($currentPage - 1) * $perPage, $perPage)->all();
    $tenantInvoices = new LengthAwarePaginator($currentPageItems, count($tenantInvoices), $perPage);
    $tenantInvoices->setPath(request()->url());

    return view('landlord.tenant-profle', compact('tenant', 'tenantInvoices', 'apartment'));
}
public function generateInvoices(Request $request, $apartment)
{
    // Run the artisan command to generate invoices for the specific apartment
    Artisan::call('invoices:generate', ['--apartment' => $apartment]);

    // Get the output and success/error message
    $output = Artisan::output();
    $success = Artisan::output() ? true : false;

    // Redirect back with a message
    return redirect()->back()->with([
        'success' => $success,
        'message' => $output,
    ]);
}

public function revertInvoices($apartmentId)
{
    // Get the current time
    $currentTime = Carbon::now();

    // Revert invoices generated in the last 10 minutes
    $revertTimeLimit = $currentTime->subMinutes(10);

    // Perform the revert operation within a transaction to ensure consistency
    DB::transaction(function () use ($apartmentId, $revertTimeLimit) {
        // Revert invoices based on the apartment and time limit
        Invoice::where('apartment_id', $apartmentId)
            ->where('created_at', '>=', $revertTimeLimit)
            ->delete();
    });

    return redirect()->back()->with('success', 'Invoices reverted successfully.');
}
public function createInvoice($apartmentId, $userId)
{
    // Logic to create a new draft invoice
    $invoice = new Invoice();
    $invoice->apartment_id = $apartmentId;
    $invoice->user_id = $userId;
    $invoice->status = 'draft'; // Set the initial status to draft
    $invoice->save();

    return redirect()->route('show-create-invoice-form', ['apartment' => $apartmentId, 'user' => $userId, 'invoiceId'=>$invoice->id])
        ->with('success', 'Draft invoice created successfully.');
}
public function showCreateInvoiceForm($apartmentId, $userId, $invoiceId)
    {
        $apartment = Apartments::findOrFail($apartmentId);
        $user = User::findOrFail($userId);
        $invoice = Invoice::findOrFail($invoiceId);
        return view('landlord.invoices.create-invoice', compact('apartment', 'user', 'invoice'));
    }

public function publishInvoice($invoiceId)
{
    // Logic to publish the invoice
    $invoice = Invoice::findOrFail($invoiceId);
    $invoice->status = 'unpaid'; // Set the invoice status to unpaid
    $invoice->save();

    return redirect()->back()->with('success', 'Invoice published successfully.');
}
}
