<?php

namespace App\Http\Controllers;


use App\Models\License;
use Illuminate\Http\Request;
use App\Models\LicensePurchase;
use Illuminate\Foundation\Auth\User;
use Illuminate\Support\Facades\Auth;

class LandlordLicenseController extends Controller
{
    //
    public function __construct()
{
    $this->middleware('auth');
}

public function show(User $user)
{
    // Ensure the user is authenticated
    if (auth()->check()) {
        // Check if the authenticated user is viewing their own license or is a landlord
        if (auth()->user()->id === $user->id || auth()->user()->isLandlord()) {
            $user = auth()->user();
            // User is authenticated and viewing their own license or is a landlord
            return view('landlord.license.licenseinfo', compact('user'));
        } else {
            // Authenticated user is not allowed to view another user's license
            abort(403); // or redirect to unauthorized page
        }
    } else {
        // User is not authenticated, redirect to login page
        return redirect()->route('login');
    }
}

// public function show(User $user){
//           // Ensure the user is authenticated
//     if (auth()->check()) {
//         // Check if the authenticated user is viewing their own license
//         if (auth()->user()->id === $user->id) {
//             $user = auth()->user();
//             // User is authenticated and viewing their own license
//             return view('landlord.license.licenseinfo', compact('user'));
//         } else {
//             // Authenticated user is not allowed to view another user's license
//             abort(403); // or redirect to unauthorized page
//         }
//     } else {
//         // User is not authenticated, redirect to login page
//         return redirect()->route('login');
//     }

// }
public function makePurchase(User $user){
     // Ensure the user is authenticated
     if (auth()->check()) {
        // Check if the authenticated user is viewing their own license or is a landlord
        if (auth()->user()->id === $user->id || auth()->user()->isLandlord()) {
            $user = auth()->user();
            // User is authenticated and viewing their own license or is a landlord
            $licenses = License::all();
            return view('landlord.license.purchase', compact('user','licenses'));
        } else {
            // Authenticated user is not allowed to view another user's license
            abort(403); // or redirect to unauthorized page
        }
    } else {
        // User is not authenticated, redirect to login page
        return redirect()->route('login');
    }
}
public function purchaseCheckout(Request $request)
{

    // Retrieve data from the request
    $selectedLicenseType = $request->input('license_type');
    // $confirmTerms = $request->input('confirm_terms');

    // Validate that the terms are confirmed
    // if (!$confirmTerms) {
    //     return redirect()->back()->with('error', 'Please confirm the license terms.');
    // }

    // Retrieve other license details based on the selected type
    $licenseDetails = $this->getLicenseDetails($selectedLicenseType);

    // Pass data to the view
    return view('landlord.license.purchase-checkout', compact('selectedLicenseType','licenseDetails'));


}
// public function purchaseCheckout(Request $request)
// {
//     // Retrieve selected license and other data from the request
//     $selectedLicenseType = $request->input('license_type');

//         //dd($selectedLicenseType);
//     // You can pass this data to the checkout page
//     return view('landlord.license.purchase-checkout', compact('selectedLicenseType'));
// }

public function purchase(Request $request)
{
    // Validate form input and process payment (if applicable)

    // Create a new LicensePurchase record
    $purchase = LicensePurchase::create([
        'user_id' => auth()->id(),
        'license_type' => $request->input('license_type'),
        'payment_status' => 'success', // You may need to adjust based on your payment integration
    ]);

    // Collect new details from the form
    $newDetails = [
        'additional_field_1' => $request->input('additional_field_1'),
        'additional_field_2' => $request->input('additional_field_2'),
        // Add more fields as needed
    ];

    // Associate the purchased license with the user and collect new details
    $user = auth()->user();
    $license = License::create([
        'user_id' => $user->id,
        'name' => 'PACMIS-' . uniqid(), // Unique name with prefix
        'type' => $purchase->license_type,
        'valid_until' => now()->addMonths(1), // Adjust expiration logic based on your rules
        // Add other necessary fields
        'additional_details' => $newDetails,
    ]);

    return redirect()->back()->with('success', 'License purchased successfully.');
}
 public function upgrade(){
    $user = auth()->user();
    return view('landlord.license.upgradelicense', compact('user'));
 }

 public function renewLicense(LicensePurchase $licensePurchase)
{
    // Validate that the license is eligible for renewal
    if ($licensePurchase->payment_status === 'success' && $licensePurchase->expiry_date && $licensePurchase->expiry_date > now()) {
        // Implement the renewal logic (use the renewLicense method from the LicensePurchase model)
        $renewalMonths = 3; // Replace with the desired renewal period
        $success = $licensePurchase->renewLicense($renewalMonths);

        if ($success) {
            return redirect()->back()->with('success', 'License renewed successfully.');
        } else {
            return redirect()->back()->with('error', 'License renewal failed.');
        }
    }

    return redirect()->back()->with('error', 'License cannot be renewed.');
}
public function processPayment(Request $request)
{
    // Retrieve data from the request
    $selectedLicenseType = $request->input('license_type');
$selectedLicenseType = str_replace('required', '', $selectedLicenseType);
$selectedLicenseType = trim($selectedLicenseType); //remove any leading or ending spaces

    $confirmTerms = $request->input('confirm_terms');

    //dd($selectedLicenseType);
    // Validate that the terms are confirmed
    if (!$confirmTerms) {
        return redirect()->back()->with('error', 'Please confirm the license terms.');
    }
     // Ensure that the license type is not empty or contains "required"
     if (empty($selectedLicenseType) || stripos($selectedLicenseType, 'required') !== false) {
        return redirect()->back()->with('error', 'Invalid license type.');
    }

    // Retrieve user information
    $user = $request->user(); // Assuming you have user authentication set up

    // Retrieve licenses from the database
    $licenses = License::all();

    // Find the license that matches the selected license type
    $license = $licenses->first(function ($license) use ($selectedLicenseType) {
        return $license['type'] === $selectedLicenseType;
    });


    // Check if the license exists
    if (!$license) {
        return redirect()->back()->with('error', 'License details not found.');
    }
    //dd($license);
    // Add logic to handle payment based on the selected payment method
    $paymentMethod = $request->input('payment_method');
    //  // Retrieve license information
    //  $licenseType = $selectedLicenseType['type'];
    //  $licensePrice = $selectedLicenseType['price'];
    //  $licenseCycle = $selectedLicenseType['expiration_cycle'];

     // Retrieve user information
     $user = $request->user(); // Assuming you have user authentication set up


    // Example: Redirect to different payment gateways based on the selected method
    switch ($paymentMethod) {
        case 'paypal':
            // Add logic to redirect to PayPal
            return redirect()->route('paypal.redirect', [
                'license_type' => $license['type'],
                'license_price' => $license['price'],
                'license_cycle' => $license['expiration_cycle'],
                'user_id' => $user->id,
                // Add other user info if needed
            ]);
            break;
        case 'visa':
            // Add logic to process Visa payment
            return redirect()->route('visa.process', [
                'license_type' => $license['type'],
                'license_price' => $license['price'],
                'license_cycle' => $license['expiration_cycle'],
                'user_id' => $user->id,
                // Add other user info if needed
            ]);
            break;
        case 'm-pesa':
            // Add logic to process M-Pesa payment
            return redirect()->route('mpesa.process-initiate', [
                'license_type' => $license['type'],
                'license_price' => $license['price'],
                'license_cycle' => $license['expiration_cycle'],
                'user_id' => $user->id,
                // Add other user info if needed
            ]);
            break;
        case 'airtel-money':
            // Add logic for cash payment
            return redirect()->route('cash.process', [
                'license_type' => $license['type'],
                'license_price' => $license['price'],
                'license_cycle' => $license['expiration_cycle'],
                'user_id' => $user->id,
                // Add other user info if needed
            ]);
            break;
        default:
            // If no valid payment method is selected, redirect back with an error message
            return redirect()->back()->withInput($request->except('_token'))->with('error', 'Invalid payment method.');
    }


    // Example success message
    return redirect()->route('landlord-license')->with('success', 'Payment processed successfully.');
}
public function success()
{
    return view('landlord.license.success');
}
// Function to retrieve license details based on the type
private function getLicenseDetails($licenseType)
{
    // Implement logic to fetch details based on the license type
    // You can customize this method based on your data structure and model relationships

    // For example, assuming you have a License model with a method to get details
   // Example: Assuming you have a License model with a method to get details
   $license = License::where('type', $licenseType)->first();

   if ($license) {
    // Compile specific columns as details
    $details = [
        'Max Users' => $license->max_users,
        'Max Rooms' => $license->max_rooms,
        'Max Apartments' => $license->max_apartments,
        'Expiration Cycle' => $license->expiration_cycle,
        'Max_landlords' => $license->max_landlords,
    ];

    // Format details as a string
    $formattedDetails = implode(', ', array_map(function ($value, $key) {
        return "$key: $value";
    }, $details, array_keys($details)));

    return $formattedDetails;
}

return 'Details not available.';
}
}
