<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\File;

class LogController extends Controller
{
    //
    public function showUserLoginLogs()
    {
        // Read the log file
        $logFile = storage_path('logs/laravel.log');
        $logContents = File::get($logFile);

        // Filter log entries containing 'User login' info
        preg_match_all("/^.*User login.*$/m", $logContents, $matches);
        $userLoginLogs = $matches[0];

        // Pass filtered log entries to the view
        return view('user_login_logs', ['userLoginLogs' => $userLoginLogs]);
    }
}
