<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\LicensePurchase;
use App\Models\LicensesInvoice;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Auth;

class MpesaPaymentController extends Controller
{
    //
    public function index(Request $request){
        // Retrieve data from the request or other sources
    $licenseType = $request->input('license_type');
    $licensePrice = $request->input('license_price');
    $licenseCycle = $request->input('license_cycle');
    $mpesaPrice=$licensePrice*140;
    $userId = $request->input('user_id');
    $user= Auth::user();

        return view('landlord.license.payment.mpesa', [
            'license_type' => $licenseType,
            'license_price' => $licensePrice,
            'license_cycle' => $licenseCycle,
            'user_id' => $userId,
            'user'=>$user,
            'license_mpesa_price'=>$mpesaPrice,
        ]);
    }
    public function process(Request $request)
{
    // Validate request data
    $request->validate([
        'amount' => 'required|numeric|min:10', // Minimum amount validation added
        'phone_number' => 'required|regex:/^254\d{9}$/',
    ]);

    // Retrieve data from the request
    $amount = $request->input('amount');
    $licenseType = $request->input('license_type');
    $userId = $request->input('user_id');
    $phoneNumber = $request->input('phone_number');

    // Check if phone number starts with '254'
    if (substr($phoneNumber, 0, 3) !== '254') {
        return redirect()->back()->with('error', 'Phone number should start with 254.');
    }

    // Process the payment logic
    // Simulate processing logic (replace with your actual logic)
    $paymentInitialization = true; // Assuming payment is successful

    if ($paymentInitialization) {
        // Create a new license purchase instance
        $licensePurchase = new LicensePurchase();
        $licensePurchase->user_id = $userId;
        $licensePurchase->license_key = 'PACMIS-' . uniqid(); // Generate or assign a license key
        $licensePurchase->payment_amount = $amount;
        $licensePurchase->status = 'pending'; // Default status
        $licensePurchase->license_type = $licenseType;

        $licensePurchase->payment_status = 'pending'; // Assuming payment is successful
        $licensePurchase->purchase_date = now(); // Current date and time
        $licensePurchase->expiry_date = now()->addMonths(1); // Set expiry date as needed
        $licensePurchase->license_status = 'unused'; // Assuming the license is active

        // Save the license purchase
        $licensePurchase->save();

        // Create a new license invoice
        $invoice = new LicensesInvoice();
        $invoice->invoice_number = 'INV' . uniqid(); // Generate a unique invoice number
        $invoice->payment_method = 'mpesa'; // Assuming payment method is M-Pesa
        $invoice->time = now();
        $invoice->user_id = $userId;
        $invoice->payment_status = 'pending';
        $invoice->license_purchase_id = $licensePurchase->id; // Use the newly created license purchase ID
        $invoice->license_key = $licensePurchase->license_key; // Use the license key from the license purchase
        $invoice->save();

        //dd($invoice->id);
        // Redirect to the callback route with success message
        return redirect()->route('mpesa.callback')->with([
            'status' => 'pending',
            'message' => 'Payment awaiting!',
            'invoice_id' => $invoice->id, // Pass the invoice ID to the callback
        ]);
    } else {
        // Redirect to the callback route with error message and old input data
        return redirect()->route('mpesa.process-initiate')
            ->withErrors(['error' => 'Payment failed. Please try again.'])
            ->withInput($request->except('_token'))
            ->with('callback_response', 'error');
    }
}

public function callback(Request $request)
{
    // Add logic to handle M-Pesa callback or response
    // Assuming the callback contains the invoice ID
    $invoiceId = $request->input('invoice_id');

    dd($invoiceId);
    //dd($request->all());
    // Simulate processing logic (replace with your actual logic)
    $paymentSuccessful = true; // Assuming payment is successful

    if ($paymentSuccessful) {
        // Update the invoice status as paid
        $invoice = LicensesInvoice::find($invoiceId);
        if ($invoice) {
            // Invoice record found, set its properties
            $invoice->payment_status = 'paid';
            $invoice->save();

            // Additional processing...
        } else {
            // Invoice record not found, handle the error or log a message
            // For example:
            Log::error('Invoice record not found for ID: ' . $invoiceId);
            // Or redirect with an error message
            return redirect()->route('mpesa.process-initiate')->with('error', 'Invoice record not found.');
        }
        // Mark the associated license purchase as active
        $licensePurchase = $invoice->licensePurchase;
        $licensePurchase->payment_status = 'paid';
        $licensePurchase->status = 'active';
        $licensePurchase->save();

        return redirect()->route('landlord-license')->with('success', 'Payment successful!');
    } else {
        return redirect()->route('mpesa.process-initiate')->with('error', 'Payment failed. Please try again.');
    }
}

}
