<?php

namespace App\Http\Controllers;

use Carbon\Carbon;
use Dompdf\Dompdf;
use Dompdf\Options;
use App\Models\User;
use App\Models\Invoice;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\View;
use Illuminate\Pagination\LengthAwarePaginator;

class PdfController extends Controller
{
    //
    use ApartmentLandlordViewController;
    public function generateApartmentThisMonthInvoicesPdf(Request $request, $apartmentId)
    {

      // Use the accessApartment method from the trait
      $data = $this->accessApartment($apartmentId);
      // Access the variables from the compact statement
    $user = $data['user'];
    $apartment = $data['apartment'];
    $apartments = $data['apartments'];

      $paymentStatus = $request->input('status', 'all'); // Default to 'all' if no status is provided
      // Step 1: Check if the authenticated user is a landlord
                  if (auth()->user()->hasRole('landlord')) {

                                  // Retrieve the selected apartment
                          // $apartment = Apartments::findOrFail($apartmentId);
                          // Check if the user is associated with the requested apartment
                          $apartment = $user->apartments()->find($apartmentId);

                          // Retrieve the list of apartments associated with the user
      $apartments = $user->apartments()->get(); // Assuming your relationship is defined correctly

                          if ($apartment) {
                               // Retrieve property data for the apartment
          $properties = $apartment->properties;

          //   // Retrieve invoices associated with rooms in the apartment using the pivot table
          $apartmentInvoices = Invoice::whereHas('rooms.apartments', function ($query) use ($apartment) {
              $query->where('apartments.id', $apartment->id);
          })->get();
                                          // Fetch all users
       $users = User::with('invoices')->get();

      $currentPage = LengthAwarePaginator::resolveCurrentPage();
      $perPage = 15; // Adjust the number of items per page as needed
      $currentPageItems = $apartmentInvoices->slice(($currentPage - 1) * $perPage, $perPage)->all();

      $apartmentInvoices = new LengthAwarePaginator($currentPageItems, count($apartmentInvoices), $perPage);

      $apartmentInvoices->setPath($request->url());

      $apartmentInvoices->each(function ($invoice) {
          $invoice->payments = json_decode($invoice->payments, true);
          $invoice->max_payment_date = collect($invoice->payments)->max('payment_date');
      });
       // Calculate compounded balances for each user
       $userCompoundedBalances = [];

       foreach ($users as $user) {
           $userCompoundedBalances[$user->id] = $this->calculateCompoundedBalances($user);
       }
// Fetch the image from the internet
//not recommended in production
$response = Http::withoutVerifying()->get('https://bootdey.com/img/Content/avatar/avatar1.png');

// Check if the request was successful and the response contains the image
if ($response->successful()) {
    // Get the content of the image
    $imageData = $response->body();

    // Convert the image data to base64 encoding
    $base64Image = base64_encode($imageData);

    // Use the base64 encoded image data in your HTML
    $imageSrc = 'data:image/png;base64,' . $base64Image;
} else {
    // Handle error if the image couldn't be fetched
    $imageSrc = "{{ asset('storage/' . $user->profile_picture) }}"; // or any default image source
}
 // Get the current month and year
 $currentMonthYear = date('F Y');
 $downloadDateTime = date('Y-m-d H:i:s');

 $headerContent = '<style>
 .header {
    //  display: flex;
    //  justify-content: center;
    //  align-items: cente;
     margin-bottom: 20px;
 }
 .header img {
    max-width: 100px; /* Adjust the maximum width of the logo */
    max-height: 50px; /* Adjust the maximum height of the logo */
    margin-right: 0.5rem; /* Add space between logo and text */
}

 .header p {
     margin: 0; /* Remove default margins */
     font-size: 18px; /* Adjust font size as needed */
 }
 </style>
 <div class="header">
   <div class="container-fluid">
     <div class="row">
       <div class="col-md-6">
       <img src="' . $imageSrc . '" alt="">
       </div>
       <div class="col-md-6">
         <!-- Third column content, if any -->
         ' . $apartment->name . '
       </div>
       </div>
     </div>
   </div>
 </div>';



 $footerContent = ' <style>

                    .footer {
                        text-align: center;
                        margin-top: 20px;
                    }
                    .footer a {
                        color: blue; /* Change link color as needed */
                        text-decoration: underline; /* Add underline to links */
                    }
                    </style>
                    <div class="footer"><a href="https://pacmis.com" target="_blank">PACMIS</a> - Simple, Efficient & Secure</div>';

          // // Filter i
      //            // Example: Fetch current month's invoices
      // $currentMonthInvoices = $apartment->invoices()
      // ->whereMonth('invoice_date', now()->month)
      // ->get();


                              // Debugging: Dump and die to check the retrieved data
                              //dd($apartmentInvoices);
                             //dd($apartments);

                             $tableContent = View::make('partials._pdf-apartmentthismonthinvoicestable', compact('userCompoundedBalances','apartmentInvoices','users','user','paymentStatus','apartment','apartments'))
                                  ->with('currentMonthInvoices');
                              } else {
                                  // The user is not associated with the requested apartment
                                  // Redirect to custom 403 page for unauthorized apartment access
                                  return abort(403, 'Unauthorized action. You do not have access to this apartment.');
                              }
                          } else {
                              // The user does not have the role of a landlord
                              // Redirect to custom 403 page for users without the landlord role
                              return abort(403, 'Unauthorized action. Only landlords can access this page.');
                          }


    // Get the HTML content of the table from the view
    // $html = View::make('partials._apartmentthismonthinvoicestable', compact('apartment', 'users'))->render();

     // Combine header, content, and footer HTML
     $html = "<html><head><style>
     body { font-family: Arial, sans-serif; }
     /* CSS styles for the header and timestamp */
    /*.header { text-align: center; margin-bottom: 20px; }*/
    .timestamp { position: absolute; top: 20px; right: 20px; }
     .footer { margin-top: 20px; }

     .table-container {
        margin-bottom: 20px;
        overflow-x: auto;
      }

      table {
        width: 90%; /* Reduce the width to 90% */
        margin: 0 auto; /* Center the table horizontally */
        border-collapse: collapse;
        max-width: 100%;
        font-size: 10px; /* Adjust the font size further */
      }

      @media print {
        @page {
          size: A4;
          margin: 0;
        }

        body {
          margin: 1.6cm;
        }
      }


     th, td { padding: 8px; border: 1px solid #ddd; }
     th { background-color: #83d5f4; }
     .odd { background-color: #f9f9f9; }
     .paid-row { background-color: #c3e6cb; }
     .unpaid-row { background-color: #f5c6cb; }
    //  .partial-row{background-color: dddbec;}
 </style>
 </head><body>";

 // Add header content
 $html .= '<div class="header"><div class="container"><div class="row">';
 $html .= '<div class="col-md-4">' . $headerContent . '</div>'; // First column for header content
 $html .= '<div class="col-md-4"><p>Invoices for ' . $currentMonthYear . '</p></div>'; // Second column
 $html .= '<div class="col-md-4">' . '<div class="timestamp">As at: ' . $downloadDateTime . '</div>' . '</div>'; // Third column for timestamp
 $html .= '</div></div></div>'; // Close container, row, and header divs

 // Add table content
 $html .= '<div class="table-container">' . $tableContent . '</div>';

 // Add footer content
 $html .= '<div class="footer">' . $footerContent . '</div>';

 // Close HTML body and document
 $html .= '</body></html>';

 // Create a new instance of Dompdf with options
 $options = new Options();
 $options->set('isHtml5ParserEnabled', true);
 $options->set('isPhpEnabled', true);
 $options->set('isRemoteEnabled', true);
 $dompdf = new Dompdf($options);

 // Load HTML content
 $dompdf->loadHtml($html);

 // Set paper size and orientation
 $dompdf->setPaper('A4', 'portrait');

 // Render the HTML as PDF
 $dompdf->render();
     // Output the generated PDF (inline or download)
     return $dompdf->stream("{$apartment->name}_{$currentMonthYear}_Invoices.pdf");
}
private function calculateCompoundedBalances($user)
{
    $compoundedBalances = [];

    // Load invoices for the user with due dates in the current month
    $currentMonth = Carbon::now();
    $invoices = $user->invoices()->whereYear('due_date', $currentMonth->year)
        ->whereMonth('due_date', $currentMonth->month)
        ->get();

    foreach ($invoices as $invoice) {
        $roomBalance = 0;

        // Query previous invoices for the same room and earlier due dates
        $previousInvoices = $user->invoices()
            ->where('room_id', $invoice->room_id)
            ->where('due_date', '<', $invoice->due_date)
            ->orderBy('due_date', 'asc')
            ->get();

        // Calculate the compounded balance for this invoice
        $roomBalance = $invoice->balance;
        foreach ($previousInvoices as $previousInvoice) {
            $roomBalance += $previousInvoice->balance;
        }

        $compoundedBalances[] = [
            'invoice' => $invoice,
            'compounded_balance' => $roomBalance,
        ];
    }

    return $compoundedBalances;
}


}
