<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Foundation\Auth\User;
use Illuminate\Support\Facades\Auth;

class ProfileController extends Controller
{
    //

    // public function __construct()
    // {
    //     $this->middleware('preventUnauthorizedAccess:userProfile');
    // }

public function showProfile(User $userProfile )
{
    // Retrieve the authenticated user
    $user = Auth::user();

    // Check if a user is authenticated
    if (!$user) {
        // Handle the case where no user is authenticated
        return redirect()->route('login'); // Redirect to the login page, for example
    }


    // Pass the data to a view and display it
    return view('profile', compact('user'));
}

public function showTenantProfile(User $userProfile )
{
    // Retrieve the authenticated user
    $user = Auth::user();

    // Check if a user is authenticated
    if (!$user) {
        // Handle the case where no user is authenticated
        return redirect()->route('login'); // Redirect to the login page, for example
    }


    // Pass the data to a view and display it
    return view('tenant.profile', compact('user'));
}
public function edit()
{
    $user = Auth::user(); // Retrieve the authenticated user
    return view('profile-edit', compact('user'));
}

public function update(Request $request)
{
    $user = Auth::user(); // Retrieve the authenticated user

    // Validate form input
    $request->validate([
        'firstName' => 'required|string|max:255',
        'surname' => 'required|string|max:255',
        'email' => 'required|string|email|max:255|unique:users,email,' . $user->id,
        'address1' => 'nullable|string|max:255',
        'country' => 'nullable|string|max:255',
        'city' => 'nullable|string|max:255',
        'industry' => 'nullable|string|max:255',
        'secondary_telephone' => 'nullable|string|max:20',
        'profile_picture' => 'nullable|image|mimes:jpeg,png,jpg,gif|max:2048', // Example validation for image upload
    ]);

    // Update user information
    $user->address_1 = $request->input('address1');
    $user->address_2 = $request->input('address2');
    $user->city = $request->input('city');
    $user->email=$request->input('email');
    $user->country = $request->input('country');
    $user->county = $request->input('county');
    $user->industry = $request->input('industry');
    $user->secondary_telephone = $request->input('secondary_telephone');
    $user->name=$request->input('surname');
    $user->first_name=$request->input('firstName');
    $user->surname=$request->input('surname');

    // Handle profile picture upload
    if ($request->hasFile('profile_picture')) {
        $imagePath = $request->file('profile_picture')->store('profile_pictures', 'public');
        auth()->user()->update(['profile_picture' => $imagePath]);
    }

    $user->save();

    return redirect()->route('profile.show')->with('success', 'Profile updated successfully');
}
}
