<?php

namespace App\Http\Controllers;

use App\Models\User;
use Illuminate\Http\Request;
use Spatie\Permission\Models\Role;


class RegistrationController extends Controller
{
    //
    public function create()
    {
        return view('auth.signup');
    }
    public function store()
    {
        $this->validate(request(), [
            'name' => 'required',
            'email' => 'required|email',
            'password' => 'required'
        ]);

        $user = User::create(request([
            'name',
            'username',
            'email',
            'password',
            'firstname',
          'lastname',
          'phone_number',
           'id_number'
        ]));
        // Assign default role to the user
        $defaultRole = Role::where('name', 'user')->first();
        if ($defaultRole) {
            $user->assignRole($defaultRole);
        }

        auth()->login($user);

        // Redirect with a welcome message
        return redirect()->to('/home')->with('success', 'Welcome. Your registration has been successful.');

    }
}
