<?php

namespace App\Http\Controllers;

use App\Models\User;
use App\Models\Rooms;
use App\Models\Apartments;
use Illuminate\Http\Request;
use App\Events\UserAssignedToRoom;

class RoomAssignmentController extends Controller
{

    public function index()
    {
        $users = User::latest();
        $rooms = Rooms::all();
        // $totalusers= Count($users);
        $apartments = Apartments::pluck('name', 'id');

        return view('admin.users', compact('users', 'rooms','apartments'));
    }

    public function usersWithRoom()
{
    // Retrieve users with their associated rooms
    $users = User::latest()->with('rooms')->get();
    $rooms = Rooms::all();

    return view('admin.users', compact('users', 'rooms'));
}

        public function roomsWithUsers()
        {
            // Retrieve users with their associated rooms
            $users = User::with('rooms')->get();
            $rooms = Rooms::all();

            return view('admin/pages/roomsoccupied', compact('users', 'rooms'));
        }
    //
    public function assignUserToRoom($roomId, $userId)
{
    // Find the room and user by their IDs
    $room = Rooms::findOrFail($roomId);
    $user = User::findOrFail($userId);

    // Check if the user is not already assigned to the room
    if (!$room->users->contains($user)) {
        $room->users()->attach($user); // Assign the user to the room
    }
    // Dispatch the UserAssignedToRoom event
    event(new UserAssignedToRoom($user, $room));
    // Redirect back with a success message or handle errors as needed
    return redirect()->back()->with('success', 'User assigned to the room successfully');

}
public function showAssignmentForm($userId)
{
    // Retrieve the user by ID
    $users = User::all(); // Retrieve all users from the database

    $user = User::findOrFail($userId);

    // Retrieve the list of available rooms
    $rooms = Rooms::all();
    $totalrooms=Rooms::Count();

    return view('admin.users', compact('users', 'rooms','totalrooms'));
}

                                public function assign(Request $request)
                                {
                                    $userId = $request->input('user_id');
                                    $roomId = $request->input('room_id');

                                    // Find the room and user by their IDs
                                    $room = Rooms::findOrFail($roomId);
                                    $user = User::findOrFail($userId);

                                    // Implement logic to assign the user to the room here
                                     // Check if the user is not already assigned to the room
                                     //dd($room);
                                     if ($room !== null) {
                                        if (!$room->users->contains($user)) {
                                            // Assign the user to the room
                                            //$room->users()->attach($user);
                                            $room->users()->attach($user, ['user_name' => $user->name]);
                                       // }
                                       return redirect()->back()->with('success', 'User assigned to room successfully');

                                    } else {
                                        // Handle the case where $room is null
                                        return redirect()->back()->with('error', 'User already has a room');
                                    }
                                    // You can use Eloquent relationships or custom logic as needed

                                    }
                                    }
                                    public function assignURoom(Request $request)
{
    // Validate the form input and retrieve the selected user, apartment, and room IDs
    $validatedData = $request->validate([
        'user' => 'required|exists:users,id',
        'apartment' => 'required|exists:apartments,id',
        'room' => 'required|exists:rooms,id',
    ]);

    // Find the user based on the provided user_id
    $user = User::findOrFail($validatedData['user']);
    $room = Rooms::findOrFail($validatedData['room']);
    // Update the user's apartment and room IDs
    $user->apartment_id = $validatedData['apartment'];
    $user->room_id = $validatedData['room'];

    if ($room !== null) {
        if (!$room->users->contains($user)) {
            // Assign the user to the room
            //$room->users()->attach($user);
            $room->users()->attach($user, ['user_name' => $user->name]);
       // }
       return redirect()->back()->with('success', 'User assigned to room successfully');

    } else {
        // Handle the case where $room is null
        return redirect()->back()->with('error', 'User already has a room');
    }
}
}

            public function showAssignForm()
                {
                    $users = User::pluck('name', 'id');
                    $apartments = Apartments::pluck('name', 'id');

                    return view('admin.users', compact('users', 'apartments'));
                }
                // public function getApartments($userId)
                //         {
                //             // Assuming you have a User model and an Apartment model
                //             $user = User::find($userId);

                //             // Assuming you have a relationship between users and apartments (e.g., user->apartments)
                //             $apartments = $user->apartments;

                //             // Prepare the data for the dropdown
                //             $apartmentOptions = [];

                //             foreach ($apartments as $apartment) {
                //                 $apartmentOptions[$apartment->id] = $apartment->name;
                //             }

                //             return response()->json($apartmentOptions);
                //         }

                        public function getAllApartments(){
                                try{
                                    $apartments = Apartments::all();


                                    return response()->json($apartments);
                                }
                              catch (\Exception $e) {
                                // Log the error
                                \Log::error($e);
                                // Return an error response
                                return response()->json(['error' => 'An error occurred while fetching apartments.'], 500);
                            }
                        }

                        public function getRoomsByApartment($apartmentId)
                            {
                                $apartment = Apartments::findOrFail($apartmentId);
                                $rooms = $apartment->rooms;


                                return response()->json($rooms);
                            }

//                             public function assignURoom(Request $request)
// {
//     // Add your assignment logic here

//     // Assuming you have user, apartment, and room IDs in the request
//     $userId = $request->input('user_id');
//     $apartmentId = $request->input('apartment_id');
//     $roomId = $request->input('room_id');

//     // Perform the assignment (e.g., update user's apartment and room IDs)
//     // Example code:
//     User::where('id', $userId)->update([
//         'apartment_id' => $apartmentId,
//         'room_id' => $roomId,
//     ]);

//     // Redirect back with a success message
//     return redirect()->back()->with('success', 'Assignment successful');
// }
public function assignApartment($roomId)
{
    // Logic to assign an apartment to the room
    // You can dispatch events or perform other necessary actions

    return redirect()->route('rooms.index');
}

public function assignTenant($roomId)
{
    // Logic to assign a tenant to the room
    // You can dispatch events or perform other necessary actions

    return redirect()->route('rooms.index');
}

public function removeTenant($roomId)
{
    // Logic to remove the tenant from the room
    // You can dispatch events or perform other necessary actions

    return redirect()->route('rooms.index');
}
}
