<?php

namespace App\Http\Controllers;

use App\Models\Service;
use Illuminate\Http\Request;

class ServiceController extends Controller
{
    //
    public function index()
    {
        $services = Service::all();
        return view('admin.services.index', compact('services'));
    }
    public function create()

{
    return view('admin.services.create');
}
public function store(Request $request)
{
    $request->validate([
        'name' => 'required|string',
        'amount' => 'required|numeric',
        'billing_cycle' => 'required|string',
        // Add validation rules for other fields
    ]);

    Service::create($request->all());

    return redirect()->route('services.index')->with('success', 'Service created successfully.');
}
public function edit(Service $service)
{
    return view('services.edit', compact('service'));
}

public function update(Request $request, Service $service)
{
    $request->validate([
        'name' => 'required|string',
        'amount' => 'required|numeric',
        'billing_cycle' => 'required|string',
        
        // Add validation rules for other fields
    ]);

    $service->update($request->all());

    return redirect()->route('services.index')->with('success', 'Service updated successfully.');
}
public function destroy(Service $service)
{
    $service->delete();

    return redirect()->route('services.index')->with('success', 'Service deleted successfully.');
}


}
