<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class SessionsController extends Controller
{
    //
     // Display the login form
     public function create()
     {
         return view('sessions.create');
     }

     // Handle the login form submission
     public function store(Request $request)
     {
         // Validate the user's login credentials
         $credentials = $request->validate([
             'email' => 'required|email',
             'password' => 'required',
         ]);

         // Attempt to log in the user
         if (Auth::attempt($credentials)) {
             // Authentication successful
             return redirect()->route('home'); // Redirect to the user's dashboard
         }

         // Authentication failed, redirect back with an error message
         return back()->with('error', 'Invalid login credentials. Please try again.');
     }

     // Handle user logout
     public function destroy()
     {
         Auth::logout();

         return redirect()->route('login'); // Redirect to the home page or another desired route
     }
}
