<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

class SettingsChangesController extends Controller
{
    //
    use ApartmentLandlordViewController;
    public function saveLocalizationSettings(Request $request, $apartmentId)
    {
        // Basic validation
        $request->validate([
            'language' => 'required|string',
            'timezone' => 'required|string',
            'currency' => 'required|string',
            // Add more validation rules if needed
        ]);

        // Use the accessApartment method from the trait
        $data = $this->accessApartment($apartmentId);

        // Access the variables from the compact statement
        $user = $data['user'];

        // Save the settings to the user or apartment (adjust based on your needs)
        $user->update([
            'language' => $request->input('language'),
            'timezone' => $request->input('timezone'),
            'currency' => $request->input('currency'),
            // Add more fields if needed
        ]);

        return response()->json(['message' => 'Settings saved successfully']);
    }
}
