<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Services\StatisticsService;

class StatisticsController extends Controller
{

    protected $statisticsService;

    public function __construct(StatisticsService $statisticsService)
    {
        $this->statisticsService = $statisticsService;
    }

    public function showStatistics()
    {
        $usersCount = $this->statisticsService->getUsersCount();
        $activeUsersCount = $this->statisticsService->getActiveUsersCount();
        $roomsCount = $this->statisticsService->getRoomsCount();
        $occupiedRoomsCount = $this->statisticsService->getOccupiedRoomsCount();

        return view('admin.users', compact('usersCount', 'activeUsersCount', 'roomsCount', 'occupiedRoomsCount'));
    }
}
