<?php

namespace App\Http\Controllers;

use App\Models\Ticket;
use App\Models\TicketResponse;
use Illuminate\Http\Request;
use RealRashid\SweetAlert\Facades\Alert; // Import SweetAlert

class SupportController extends Controller
{
    //
    // public function index(){
    //     return view('admin/supporttickets');
    // }
    public function index()
    {
        // Retrieve only tickets with an "open" status
        $tickets = Ticket::where('status', 'open')->get();

        return view('admin/tickets/supporttickets', compact('tickets'));
    }

    public function show(Ticket $ticket)
    {


          // Ensure that the 'replies' relationship is loaded.
          $ticket->load('responses.user'); // Load the replies and user information
        return view('admin/tickets/showticket', compact('ticket'));
    }

    public function reply(Request $request, Ticket $ticket)
    {
        // Validate the reply input, e.g., check for required fields.
    $request->validate([
        'message' => 'required',
    ]);
    // Get the authenticated user's ID
    $user_id = auth()->user()->id;

    // Create a new reply associated with the ticket.
    $ticket->responses()->create([
        'message' => $request->input('message'),
        'user_id' => auth()->user()->id, // Assuming you're using authentication
    ]);
    // // Associate the response with the ticket
    //     $ticket->responses()->save($ticketResponse);

    // Update the ticket status (e.g., set it to "closed").
    $ticket->update(['status' => 'closed']);
    // Show a SweetAlert2 pop-up message
    Alert::success('Reply Sent', 'Your reply has been sent to ' . $ticket->user->name);

    return redirect()->route('tickets.index', $ticket);

    }
    public function updateStatus(Request $request, $ticketId)
{
    $ticket = Ticket::find($ticketId);

    if (!$ticket) {
        return response()->json(['message' => 'Ticket not found'], 404);
    }

    $newStatus = $request->input('status');
    $ticket->status = $newStatus;
    $ticket->save();

    return response()->json(['message' => 'Status updated successfully'], 200);
}
}
