<?php

namespace App\Http\Controllers;

use App\Models\User;
use App\Models\Apartments;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\ApartmentLandlordViewController;

class TableController extends Controller
{
    //
    use ApartmentLandlordViewController;
    public function updateApartmentUserTableData(Request $request, $apartmentId)
    {

        try {
            // Log the apartmentId to check if it's correct
            \Log::info("Apartment ID: {$apartmentId}");

         // Use the accessApartment method from the trait
         $data = $this->accessApartment($apartmentId);
         // Access the variables from the compact statement
     $user = $data['user'];
     $apartment = $data['apartment'];
     $apartments = $data['apartments'];
            // Log the apartment data to check if it's found
            \Log::info("Apartment Data: " . json_encode($apartment));

            // Ensure the apartment exists
            if (!$apartment) {
                return response()->json(['success' => false, 'message' => 'Apartment not found']);
            }
// Enable query log
DB::enableQueryLog();

            // Fetch users with rooms associated with the given apartment
            $usersWithRooms = User::whereHas('rooms', function ($query) use ($apartmentId) {
                // Assuming you have a relationship between rooms and apartments
                $query->whereHas('apartments', function ($apartmentQuery) use ($apartmentId) {
                    $apartmentQuery->where('apartment_id', $apartmentId);
                });
            })->get();
// Log the queries
\Log::info(DB::getQueryLog());
           // Check if usersWithRooms has data
        if ($usersWithRooms->isEmpty()) {
            return response()->json(['success' => true, 'message' => 'No data available', 'data' => []]);
        }

        // Render the view with the updated data
        $view = view('landlord.users.add-user', compact('usersWithRooms', 'apartment','apartments'))->render();

        return response()->json(['success' => true, 'data' => $view, 'raw_data' => $usersWithRooms]);
    } catch (\Exception $e) {
        return response()->json(['success' => false, 'message' => $e->getMessage()]);
    }
}
}
