<?php

namespace App\Http\Controllers;

use App\Models\Ticket;
use Illuminate\Http\Request;

class TicketController extends Controller
{
    //
    public function index()
    {
        return view('/user/ticket');
    }
    public function create()
{
    return view('/user/ticket');
}

public function store(Request $request)
{
    $validatedData = $request->validate([
        'subject' => 'required|string|max:255',
        'description' => 'required|string',
    ]);

    // Create a new ticket
    $ticket = new Ticket();
    $ticket->subject = $validatedData['subject'];
    $ticket->description = $validatedData['description'];
    $ticket->user_id = auth()->user()->id; // Associate the ticket with the authenticated user
    $ticket->save();

    return redirect()->back()->with('success', 'Ticket created successfully!');
}

}
