<?php

namespace App\Http\Controllers;


use Carbon\Carbon;
use App\Models\User;
use App\Models\Rooms;
use App\Models\Payment;

use App\Models\UserLog;
use App\Models\Apartments;
use Illuminate\Http\Request;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\DB;
use Spatie\Permission\Models\Role;
use App\Http\Resources\UserResource;
use Illuminate\Support\Facades\Auth;
use App\Http\Resources\v1\TenantResource;
use Illuminate\Support\Facades\Validator;
use Illuminate\Pagination\LengthAwarePaginator;
use App\Http\Controllers\ApartmentLandlordViewController;

class UserController extends Controller
{
    //
    use ApartmentLandlordViewController;
    public function index(Request $request)
    {
        $users = User::all();

        if ($request->wantsJson()) {
            return response()->json(['users' => $users])->header('Content-Type', 'application/json');
        }

        return view('user.home', compact('users'));
    }

public function show(User $user)
{
return $user;
}


    public function dashboard()
    {
        $userRooms = auth()->user()->rooms; // Retrieve rooms associated with the authenticated user
        // Fetch user, room, and apartment information
        //$user = auth()->user();
        //$room = $user->room;
        //$apartment = $room->apartment;

        return view('user.dashboard', compact('userRooms'));
    }

public function getUsersCount()
    {   $users=User::all();
        $totalusers=User::count();
        $rooms=Rooms::all();
        return view('admin.users', compact('users', 'totalusers','rooms'));
        //->with('/admin/pages/roomsoccupied', view('/admin/pages/roomsoccupied', compact('rooms', 'totalrooms')));

    }

    public function getRoomsCount()
    {
        $rooms=Rooms::all();
        $totalrooms=Rooms::count();

        return view('admin.pages.roomsoccupied', compact('totalrooms','rooms'));
    }

    public function showLandlords(){
        $users=User::all();
        $landlords = User::where('is_admin', 2)->get();
        return view('admin.landlords', compact('landlords','users'));
    }
    public function showCaretakers(){
        $users=User::all();
        return view('admin.caretakers', compact('users'));
    }

        public function room()
        {
            // Fetch and display the user's room information
            $user = auth()->user();
            return view('user.dashboard', ['user' => $user]);
        }

        public function apartment()
        {
            // Fetch and display the user's apartment information
            $user = auth()->user();
            return view('user.dashboard', ['user' => $user]);
        }
        public function usersInApartment(Apartments $apartment)
{
    // Use the accessApartment method from the trait
    $data = $this->accessApartment($apartment);
     // Access the variables from the compact statement
   $user = $data['user'];
   $apartment = $data['apartment'];
   $apartments = $data['apartments'];
    $usersInApartment = $apartment->users()->with('roles')->get();

    // Calculate the count of roles for each user
    $usersInApartment->each(function ($user) {
        $user->roleCount = $user->roles->count();
    });
    $totalUsers = $usersInApartment->count();
     $usersWithRooms = $apartment->users()->with('rooms')->get();
$usersWithoutRooms = User::whereDoesntHave('rooms')->get();
// $usersWithRooms = User::whereHas('rooms', function ($query) use ($apartment) {
//     $query->where('apartment_id', $apartment->id);
// })->get();
    return view('landlord.users-in-apartment', compact('apartment','apartments', 'usersInApartment', 'totalUsers', 'usersWithRooms','usersWithoutRooms'));
}
public function landlords()
    {
        $landlords = User::where('role', 'landlord')->get();
        return view('admin.landlords', compact('landlords'));
    }
public function apartmentLandlords(Apartments $apartment){
    // Use the accessApartment method from the trait
    $data = $this->accessApartment($apartment);

    // Access the variables from the compact statement
    $user  = $data['user'];
    $apartment = $data['apartment'];
    $apartments = $data['apartments'];


    if ($apartment) {
        $usersWithRoleLandlord = $apartment->users()
            ->wherePivot('role', 'landlord')
            ->get();

    } else {

        // Redirect to a 403 page
        abort(403, 'Unauthorized action.');
    }
    return view('landlord.landlords', compact('apartment','apartments'));
}
public function apartmentCaretakers(Apartments $apartment){
    // Use the accessApartment method from the trait
    $data = $this->accessApartment($apartment);

    // Access the variables from the compact statement
    $user  = $data['user'];
    $apartment = $data['apartment'];
    $apartments = $data['apartments'];


    if ($apartment) {
        $usersWithRoleCaretaker = $apartment->users()
            ->wherePivot('role', 'caretaker')
            ->get();

    } else {

        // Redirect to a 403 page
        abort(403, 'Unauthorized action.');
    }
    return view('landlord.caretakers', compact('apartment','apartments','usersWithRoleCaretaker'));
}
    public function usersWithRolesInApartment(Apartments $apartment, $tenant)
    {
         // Use the accessApartment method from the trait
         $data = $this->accessApartment($apartment);

         // Access the variables from the compact statement
         //$user  = $data['user'];
         $apartment = $data['apartment'];
         $apartments = $data['apartments'];

         $usersInApartment = $apartment->users()->with('roles')->get();

        // Calculate the count of roles for each user
        $usersInApartment->each(function ($user) {
            $user->roleCount = $user->roles->count();
        });
        $totalUsers = $usersInApartment->count();
        if ($apartment) {
            $usersWithRooms = $apartment->users()
                ->wherePivot('role', 'tenant')
                ->get();

                $usersWithoutRooms = $apartment->users()
                ->wherePivot('role', 'guest')
                ->get();

            // Now you can use $usersWithRooms as needed

            // Find the specific user based on the provided $tenant ID
    $user = $usersInApartment->firstWhere('id', $tenant);

        } else {
            // Handle the case when $apartment is null, for example, redirect to an error page
            //return redirect()->route('error.page');
            // Redirect to a 403 page
    abort(403, 'Unauthorized action.');
        }

    // $usersWithRooms = User::whereHas('rooms', function ($query) use ($apartment) {
    //     $query->where('apartment_id', $apartment->id);
    // })->get();

    // Debug statement
//dd($usersInApartment);
        return view('landlord.users-with-roles-in-apartment', compact('apartment','apartments', 'usersInApartment', 'totalUsers', 'usersWithRooms','usersWithoutRooms'));
    }

    // UserController.php
public function updateTenantProfile(Request $request, $apartment, $tenant)
{
    // Your logic to update the tenant's profile goes here

    // Example: Update the user's profile
    $user = User::find($tenant);
    $user->update([
        'first_name' => $request->input('first_name'),
        'last_name' => $request->input('last_name'),
        // Add other fields as needed
    ]);

    // Example: Log the update
    UserLog::create([
        'user_id' => $tenant,
        'apartment_id' => $apartment,
        'action' => 'profile_update',
        'old_data' => json_encode($user->getOriginal()), // Save the original data
        'new_data' => json_encode($user->toArray()), // Save the updated data
    ]);

    return redirect()->back()->with('success', 'Profile updated successfully');
}


//     public function userProfileInApartment(Apartments $apartment, $usersInApartment, $section = null)
//     {
//          // Use the accessApartment method from the trait
//          $data = $this->accessApartment($apartment);

//          // Access the variables from the compact statement
//         // $user  = $data['user'];
//          $apartment = $data['apartment'];
//          $apartments = $data['apartments'];

//          $usersInApartment = $apartment->users()->with('roles')->get();

//         // Calculate the count of roles for each user
//         $usersInApartment->each(function ($user) {
//             $user->roleCount = $user->roles->count();
//         });
//         $totalUsers = $usersInApartment->count();
//         if ($apartment) {
//             $usersWithRooms = $apartment->users()
//                 ->wherePivot('role', 'tenant')
//                 ->get();

//                 $usersWithoutRooms = $apartment->users()
//                 ->wherePivot('role', 'guest')
//                 ->get();
//             // Now you can use $usersWithRooms as needed

//              // Find the specific user based on the provided $tenant ID
//     $user = $usersInApartment->firstWhere('id', $usersInApartment);
//         } else {
//             // Handle the case when $apartment is null, for example, redirect to an error page
//             //return redirect()->route('error.page');
//             // Redirect to a 403 page
//     abort(403, 'Unauthorized action.');
//         }

//         return view('landlord.tenant-profle', compact('apartment','apartments','user', 'usersInApartment', 'totalUsers', 'usersWithRooms','usersWithoutRooms'));
//     // $usersWithRooms = User::whereHas('rooms', function ($query) use ($apartment) {
//     //     $query->where('apartment_id', $apartment->id);
//     // })->get();

//     // Debug statement
// //dd($usersInApartment);

//     }
    // public function userUpdateProfileInApartment(Request $request, $apartment, $tenant)
    // {

//         \Log::info('Request received:', ['data' => $request->all()]);
// \Log::info('Apartment ID:', ['apartment_id' => $apartment]);
// \Log::info('Tenant ID:', ['tenant_id' => $tenant]);

//         // Incorrect usage, passing an array directly
// //\Log::info('Log message', ['key' => 'value']);

// // Correct usage, converting the array to a string
// \Log::info('Log message ' . json_encode(['key' => 'value']));
//         // Ensure the authenticated user is the landlord and has access to the specified apartment
//         $landlordId = auth()->id();
//         $apartment = Apartments::where('id', $apartment)
//             ->where('landlord_id', $landlordId)
//             ->first();

//         // Ensure the tenant belongs to the specified apartment
//         $user = User::where('id', $tenant)
//             ->whereHas('apartments', function ($query) use ($apartment) {
//                 $query->where('apartment_id', $apartment->id);
//             })
//             ->first();

//         if (!$apartment || !$user) {
//             return response()->json(['success' => false, 'message' => 'Invalid apartment or user']);
//         }

//         // Extract data from the request
//         $formData = $request->all();

//         // Add your logic to save the profile here
//         // Use $apartment and $user variables to identify the specific apartment and user

//         // Return a response indicating success or failure
//         return response()->json(['success' => true]);
//     }
public function userProfileInApartment(Apartments $apartment, $tenantId, $section = null)
{
    // Use the accessApartment method from the trait
    $data = $this->accessApartment($apartment);

    // Access the variables from the compact statement
    $apartment = $data['apartment'];
    $apartments = $data['apartments'];
    $apartmentId = $apartment->id;
    $usersInApartment = $apartment->users()->with('roles')->get();

    // Calculate the count of roles for each user
    $usersInApartment->each(function ($user) {
        $user->roleCount = $user->roles->count();
    });

    $totalUsers = $usersInApartment->count();

    // Find the specific user based on the provided $tenant ID
    $user = $usersInApartment->firstWhere('id', $tenantId);

    if (!$user) {
        // Handle the case when $user is not found, for example, redirect to an error page
        // return redirect()->route('error.page');
        // Redirect to a 404 page
        abort(404, 'User not found.');
    }
// Ensure the tenant belongs to the specified apartment
$tenant = User::where('id', $tenantId)
    ->whereHas('apartments', function ($query) use ($apartment) {
        $query->where('apartment_id', $apartment->id);
    })
    ->first();

// Ensure the user exists and belongs to the specified apartment
if (!$tenant) {
    return response()->json(['success' => false, 'message' => 'Invalid user or user does not belong to the specified apartment']);
}

$activeTenantId = $tenant->id;

// Check if the tenant has a room in the specified apartment
$hasRoomInApartment = $tenant->rooms()->whereHas('apartments', function ($query) use ($apartment) {
    $query->where('apartments.id', $apartment->id);
})->exists();

if ($hasRoomInApartment) {
    // Retrieve invoices associated with the tenant and belonging to the apartment
    $tenantInvoices = $tenant->invoices()->whereHas('rooms.apartments', function ($query) use ($apartment) {
        $query->where('apartments.id', $apartment->id);
    })->get();

    // Retrieve other related data
    $tenantRooms = $tenant->rooms;
    $tenantRoles = $tenant->roles;
    $tenantTickets = $tenant->tickets;

    // Calculate the compounded balance
    $compoundedBalance = $tenantInvoices->sum('balance');
} else {
    // Tenant does not have a room in the specified apartment
    $tenantInvoices = collect(); // Empty collection
    $tenantRooms = collect(); // Empty collection
    $tenantRoles = collect(); // Empty collection
    $tenantTickets = collect(); // Empty collection
    $compoundedBalance = 0;
}

// Calculate the compounded balance
$compoundedBalance = 0;

foreach ($tenantInvoices as $invoice) {
    // Assuming there's a 'total_amount' field in your invoice model
    $compoundedBalance += $invoice->balance;
}


//Rooms section
 // Retrieve all distinct room statuses from the database
// Define all possible room status values (update with your actual enum values)
$allStatusValues = ['unoccupied', 'booked', 'available', 'under renovation', 'not available'];

// Retrieve all distinct room statuses from the database
$occupiedStatuses = $tenantRooms->pluck('status')->unique()->toArray();

// Calculate the available statuses by subtracting occupied statuses from all statuses
$availableStatuses = array_diff($allStatusValues, $occupiedStatuses);

// Check if the user has a room in the specified apartment
$room = $tenant->rooms()
        ->whereHas('apartments', function ($query) use ($apartment) {
        $query->where('apartment_id', $apartment->id);
        })->get();

if ($room) {
    foreach ($tenantRooms as $room) {
        $roomStatus = $room->status;
    }
} else {
    // The user doesn't have a room in the specified apartment
    $roomStatus = null;
}

// dd($availableStatuses);
 // Fetch tenant services
 $tenantservices = $user->services()->withPivot('signup_date', 'next_due_date')->get();

 // Retrieve transactions associated with the user
 // Initialize an empty array to store transactions
$transactions = [];

// Iterate through each invoice
foreach ($tenantInvoices as $invoice) {
    // Parse JSON data from the payments column
    $payments = json_decode($invoice->payments, true);

    // Check if payments exist
    if (is_array($payments)) {
        // Iterate through each payment in the invoice
        foreach ($payments as $payment) {
            // Format payment data and add it to the transactions array
            $transactions[] = [
                'invoice_number' => $invoice->invoice_number,
                'payment_date' => $payment['payment_date'],
                'payment_amount' => $payment['payment_amount'],
                'payment_method' => $payment['payment_method'],
                'transaction_id' => $payment['transaction_id'],
                'transaction_fee' => $payment['transaction_fee']
            ];
        }
    }
}

// Convert the transactions array to a collection
$transactions = new Collection($transactions);

// // Paginate the invoices if needed
// $perPage = 15;
// $currentPage = LengthAwarePaginator::resolveCurrentPage();
// $currentPageItems = $tenantInvoices->slice(($currentPage - 1) * $perPage, $perPage)->all();
// $tenantInvoices = new LengthAwarePaginator($currentPageItems, count($tenantInvoices), $perPage);
// $tenantInvoices->setPath(request()->url());
    // Now you can use $user and other variables as needed
    //  // Check if a specific section is provided
    //  $sections = ['summary-section', 'profile-section', 'users-section', 'contacts-section', 'products-section', 'invoices-section', 'tickets-section'];

    //  if ($section && in_array($section, $sections)) {
    //      // Redirect to the specified section
    //      return view('landlord.tenant-profle', compact('apartment','apartmentId', 'apartments', 'user', 'usersInApartment', 'totalUsers', 'section', ));
    //  }


    return view('landlord.tenant-profle', compact('apartment', 'apartmentId', 'activeTenantId', 'apartments', 'user', 'usersInApartment',
    'totalUsers','tenant', 'tenantInvoices', 'apartment','tenantRooms', 'tenantservices','transactions', 'tenantTickets',
    'availableStatuses','compoundedBalance','tenantRoles'));
}


public function userUpdateProfileInApartment(Request $request, $apartmentId, $tenantId)
{
    try {
        // Validation rules
            $rules = [
                'firstName' => 'required|string|max:255',
                'lastName' => 'required|string|max:255',
                'email' => 'required|email|max:255',
                'phone' => 'nullable|string|max:20',
                // Add more validation rules for other fields as needed
            ];

            // Custom validation messages
            $messages = [
                'required' => 'The :attribute field is required.',
                'string' => 'The :attribute field must be a string.',
                'max' => 'The :attribute field must not exceed :max characters.',
                'email' => 'The :attribute field must be a valid email address.',
            ];

            // Validate the request data
            $validator = Validator::make($request->all(), $rules, $messages);

        // If validation fails, return an error response
        if ($validator->fails()) {
            return response()->json(['success' => false, 'message' => $validator->errors()->first()]);
        }

        // Ensure the authenticated user is the landlord and has access to the specified apartment
        $data = $this->accessApartment($apartmentId);
        $user = $data['user'];
        $apartment = $data['apartment'];

        // Ensure the apartment exists and the authenticated user is the landlord
        if (!$apartment) {
            return response()->json(['success' => false, 'message' => 'Invalid apartment or unauthorized access']);
        }

        // Ensure the tenant belongs to the specified apartment
        $tenant = User::where('id', $tenantId)
            ->whereHas('apartments', function ($query) use ($apartment) {
                $query->where('apartment_id', $apartment->id);
            })
            ->first();

        // Ensure the user exists and belongs to the specified apartment
        if (!$tenant) {
            return response()->json(['success' => false, 'message' => 'Invalid user or user does not belong to the specified apartment']);
        }

        // Log the details before updating
        \Log::info("Before Update: " . json_encode($tenant->toArray()));

        // Save user profile in the users table
        $tenant->update([
            'first_name' => $request->input('firstName'),
            'last_name' => $request->input('lastName'),
            // Add more fields as needed
        ]);

        // Log the details after updating
        \Log::info("After Update: " . json_encode($tenant->fresh()->toArray()));

        // Save log details to a dedicated log table
        UserLog::create([
            'user_id' => auth()->id(),
            'action' => 'profile_updated',
            'apartment_id' => $apartment->id,
            'tenant_id' => $tenant->id,
            'changed_fields' => json_encode($request->all()), // Save changed fields as JSON
            'ip_address' => $request->ip(),
        ]);

        return response()->json(['success' => true, 'message' => 'Profile saved successfully']);
    } catch (\Exception $e) {
        \Log::error($e);

        return response()->json(['success' => false, 'message' => 'An error occurred while saving the profile. Please try again.']);
    }
}

    public function saveTenantProfile(Request $request, $apartmentId, $userId)
    {
        // Validate the incoming request data if needed
        $validatedData = $request->validate([
            'firstName' => 'required|string|max:255',
            'lastName' => 'required|string|max:255',
            'email' => 'required|email|max:255',
            // Add more validation rules for other fields
        ]);

        // Retrieve the user from the database
        $user = User::findOrFail($userId);

        // Update user information
        $user->first_name = $validatedData['firstName'];
        $user->last_name = $validatedData['lastName'];
        $user->email = $validatedData['email'];
        // Update other fields as needed

        // Save the changes to the database
        $user->save();

        // You can return a response or redirect back to the profile page
        return response()->json(['success' => true, 'message' => 'Profile saved successfully']);
    }

    public function searchUser(Request $request)
{
    $userId = $request->input('userId');
    $phoneNumber = $request->input('phoneNumber');
    $nationalId = $request->input('nationalId');

    // Perform the search in the users table
    $user = User::where('id', $userId)
        ->where('phone_number', $phoneNumber)
        ->where('national_id_number', $nationalId)
        ->first();
        \Log::info('Response: ' . json_encode($user));
        if (!$user) {
            return response()->json(null);
        }

    return response()->json($user);
}
public function addUserToApartment(Request $request)
{
    try {
        $userId = $request->input('userId');
        $apartmentId = $request->input('apartmentId');

        // Check if the user is already associated with the apartment
        $existingAssociation = DB::table('user_apartment')
            ->where('user_id', $userId)
            ->where('apartment_id', $apartmentId)
            ->exists();

        if ($existingAssociation) {
            return response()->json(['message' => 'User is already associated with the apartment.']);
        }

        // Add the user to the apartment with a specific role
        $apartment = Apartments::find($apartmentId);
        if (!$apartment) {
            return response()->json(['success' => false, 'error' => 'Apartment not found.']);
        }

        $apartment->users()->attach($userId, ['role' => 'guest']);

        return response()->json(['success' => true, 'message' => 'User added to the apartment successfully.']);
    } catch (\Exception $e) {
        // Log the exception for debugging
        \Log::error('Error adding user to apartment: ' . $e->getMessage());

        return response()->json(['success' => false, 'error' => 'Failed to add user to the apartment. Please try again.']);
    }
}

// public function addUserToApartment(Request $request)
// {
//     $userId = $request->input('userId');
//     $apartmentId = $request->input('apartmentId');

//     // Confirm that the authenticated user is the owner of the apartment
//     if (auth()->user()->ownsApartment($apartmentId)) {
//         // Check if the user is not already added to the apartment
//         if (!UserApartment::where('user_id', $userId)->where('apartment_id', $apartmentId)->exists()) {
//             // Add the user to the apartment
//             UserApartment::create([
//                 'user_id' => $userId,
//                 'apartment_id' => $apartmentId,
//                 // Add other fields as needed
//             ]);

//             return response()->json(['success' => true]);
//         }

//         return response()->json(['success' => false, 'message' => 'User is already added to the apartment.']);
//     }

//     return response()->json(['success' => false, 'message' => 'Unauthorized action. You do not own this apartment.']);
// }

    public function sendJoinRequest($apartmentId)
{
    $user = auth()->user();

    // Check if the user has already sent a request
    if (!$user->requests()->where('apartment_id', $apartmentId)->exists()) {
        $request = new Request([
            'apartment_id' => $apartmentId,
            'status' => 'pending',
        ]);

        $user->requests()->save($request);

        // Optionally, you can notify the landlord about the new request
        // (You might use events or notifications for this purpose)

        return redirect()->back()->with('success', 'Join request sent successfully.');
    }

    return redirect()->back()->with('error', 'You already sent a request to join this apartment.');
}

}

