<?php

namespace App\Http\Controllers;

use App\Models\Rooms;
use App\Models\Services;
use App\Models\Watchlist;
use App\Models\Apartments;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class WatchlistController extends Controller
{
    //

    public function addToWatchlist(Request $request)
    {
        dd($request->all());
        \Log::info('Request Data:', $request->all());

        // Get the authenticated user
        $user = Auth::user();


        if ($user) {
            \Log::info('Authenticated User ID:', ['user_id' => $user->id, 'email' => $user->email]);

            // Validate the incoming request data
            $request->validate([
                'watchable_id' => 'required',
                'watchable_type' => 'required|in:Room,Apartment,Service',
            ]);

            // Create a new watchlist entry
            $watchlist = Watchlist::create([
                'user_id' => $user->id,
                'watchable_id' => $request->watchable_id,
                'watchable_type' => $request->watchable_type,
            ]);

            // Return a response indicating success
            return response()->json(['message' => 'Item added to watchlist successfully', 'watchlist' => $watchlist]);
        } else {
            // Return an error response if user is not authenticated
            return response()->json(['error' => 'User is not authenticated'], 401);
        }
    }
}
