<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class ApartmentAccessMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next)
    {
        $user = Auth::user();

        // // Check if the user is a landlord or caretaker
        // if ($user->hasAnyRole(['landlord', 'caretaker'])) {
        //     $apartmentId = $request->route('apartment_id'); // Adjust this according to your route parameter
        //     // Check if the user is assigned to the requested apartment
        //     if ($user->hasAccessToApartment($apartmentId)) {
        //         return $next($request);
        //     }
        // }

        // return abort(403); // Redirect to a 403 Forbidden page if access is denied
        if ($user->hasRole('landlord')) {
            return $next($request); // Landlords can access apartment properties
        }

        // For other roles, restrict access to room-related views
        if ($user->hasRole('tenant') || $user->hasRole('caretaker')) {
            return redirect()->route('room.index'); // Redirect them to their assigned room page
        }

        return redirect('/home'); // Handle other scenarios
    }
}
