<?php

namespace App\Http\Middleware;

use Illuminate\Auth\Middleware\Authenticate as Middleware;

class Authenticate extends Middleware
{
    /**
     * Get the path the user should be redirected to when they are not authenticated.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return string|null
     */
    protected function redirectTo($request)
    {
        if (!$request->expectsJson()) {
            // Check if the user is authenticated
            if (auth()->check()) {
                // Check if the authenticated user is an admin
                if (auth()->user()->isAdmin()) {
                    return route('admin-home'); // Redirect to the admin dashboard
                }

                return route('/home'); // Redirect to the default home page
            }

            return route('login'); // Redirect to the login page if the user is not authenticated
        }
    }


}
