<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class LandlordApartmentAccessMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle($request, Closure $next)
    {
        $user = $request->user(); // Get the authenticated user
        $apartmentId = $request->route('apartment'); // Get the requested apartment's ID

        if ($user->hasRole('landlord')) {
            // Check if the landlord is assigned to the requested apartment
            if ($user->apartments->contains('id', $apartmentId)) {
                return $next($request);
            }
        }

        // Redirect or handle unauthorized access
        return redirect('/home'); // You can customize the redirect route
    }
}
