<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Gate;


class PreventUnauthorizedAccess
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next, $userProfile)
    {
        if ($request->user()->isUser()) {
            if (Gate::denies('view', $userProfile)) {
                return abort(403);
            }
        } elseif ($request->user()->isLandlord()) {
            if (Gate::denies('landlordView', $userProfile)) {
                return abort(403);
            }
        } elseif ($request->user()->isAdmin()) {
            if (Gate::denies('adminView', $userProfile)) {
                return abort(403);
            }
        } elseif ($request->user()->isCaretaker()) {
            if (Gate::denies('caretakerView', $userProfile)) {
                return abort(403);
            }
        }
        return $next($request);
    }
}
