<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class RoleHomeRedirectMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */

     public function handle($request, Closure $next)
    {
        if (auth()->check()) {
            $userRoles = auth()->user()->roles->pluck('name')->toArray();

            // Check if user has no roles
            if (empty($userRoles)) {
                // Prevent redirect loop by not redirecting to the same route
                if ($request->path() !== 'user') {
                    return redirect('/user')->with('error', 'Your account does not have any roles assigned.');
                }
            } else {
                $redirectPath = $this->getRedirectPath($userRoles);

                // Prevent redirect loop by not redirecting to the same route
                if ($request->path() !== ltrim($redirectPath, '/')) {
                    return redirect($redirectPath)->with([
                        'error' => session('error'), // Include error message if present
                        'success' => session('success') // Include success message if present
                    ]);
                }
            }
        }

        return $next($request);
    }

    protected function getRedirectPath($userRoles)
    {
        if (in_array('admin', $userRoles)) {
            return '/admin';
        } elseif (in_array('caretaker', $userRoles)) {
            return '/caretaker';
        } elseif (in_array('landlord', $userRoles)) {
            return '/landlord';
        } elseif (in_array('tenant', $userRoles)) {
            return '/tenant';
        } elseif (in_array('guest', $userRoles)) {
            return '/guest';
        } else {
            // Redirect users with undefined roles to their respective role pages
            return '/' . $userRoles[0];
        }
    }
}
