<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class RoleMiddleware
{
    //implement on login page and redirection of common custom views present across all users like /home
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle($request, Closure $next)
    {

        if (auth()->check()) {
            $user = auth()->user();
            $role = $user->roles->pluck('name')->first();

              // Check if the user has no role (or if the role is not defined)
        if (!$role) {
            return redirect('/home');
        }
            // Get the current request path
            $currentPath = $request->getPathInfo();

            // Check if the user is already on the intended redirection path
            if ($role === 'admin' && $currentPath === '/admin') {
                return $next($request);
            } elseif ($role === 'landlord' && $currentPath === '/landlord') {
                return $next($request);
            } elseif ($role === 'caretaker' && $currentPath === '/caretaker') {
                return $next($request);
            } elseif ($role === 'tenant' && $currentPath === '/tenant') {
                return $next($request);
            } elseif ($role === 'guest' && $currentPath === '/user') {
                return $next($request);
            }

            switch ($role) {
                case 'admin':
                    return redirect('/admin/dashboard');
                case 'landlord':
                    return redirect('/landlord');
                case 'caretaker':
                    return redirect('/caretaker');
                case 'tenant':
                    return redirect('/tenant');
                case 'guest':
                        return redirect('/guest');
                default:
                    return redirect('/home');
            }
        }

        return $next($request);


}
}

