<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class RoleRedirectMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle($request, Closure $next)
{
    if (auth()->check()) {
        $user = auth()->user();
        $role = $user->roles->pluck('name')->first();

        // Check if the user has no role (or if the role is not defined)
        if (!$role) {
            return redirect('/home')->with('error', 'Your account does not have a valid role.');
        }

        // Define the intended redirection paths based on roles
        $intendedPaths = [
            'admin' => '/admin',
            'landlord' => '/landlord',
            'caretaker' => '/caretaker',
            'tenant' => '/tenant',
            'guest' => '/user',
        ];

        // Check if the user's intended path is valid
        if (array_key_exists($role, $intendedPaths)) {
            $intendedPath = $intendedPaths[$role];

            // Check if the user is already on the intended redirection path
            if ($request->path() !== ltrim($intendedPath, '/')) {
                return redirect($intendedPath)->with([
                    'error' => session('error'), // Include error message if present
                    'success' => session('success') // Include success message if present
                ]);
            }
        } else {
            // If the role is not recognized, redirect to the home page with an error message
            return redirect('/home')->with('error', 'Your account has an unrecognized role.');
        }
    }

    return $next($request);
}

}
