<?php

namespace App\Listeners;

use App\Events\UserAssignedToRoom;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;


class ChangeUserRoleToTenant
{
    public function __construct()
    {
        //
    }

    public function handle(UserAssignedToRoom $event)
    {
        $user = $event->user;

        // Check if the user doesn't have the "tenant" role
        if (!$user->hasRole('tenant')) {
            // Assign the "tenant" role to the user
            $user->assignRole('tenant');
        }
    }
}
