<?php

namespace App\Models;

use App\Models\Apartments;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class FixedExpense extends Model
{
    use HasFactory;
    protected $fillable = ['name','amount', 'frequency', 'start_date'];

    // Define Many-to-One Relationship with Apartment
    public function apartment()
    {
        return $this->belongsTo(Apartments::class, 'apartment_id',);
    }
}
