<?php

namespace App\Models;

use App\Models\User;
use App\Models\Invoice;
use App\Models\Apartments;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Rooms extends Model
{
    use HasFactory;
    protected $fillable = [
         'room_number',
         'price',
         'payment_status',
         'status',
         'occupied_status',
         'room_size'];


    /**
     * Rooms to Users
     *
     * Many to many
     */
         public function users()
         {
             return $this->belongsToMany(User::class, 'rooms_user', );
         }

//          public function apartments()
// {
//     return $this->belongsToMany(Apartments::class, 'apartments_rooms')
//         ->withPivot('room_number', 'apartment_name');
// }


/**
     * Rooms to Users
     *
     * Many to many
     */
    public function apartments()
{
    return $this->belongsToMany(Apartments::class, 'apartments_rooms', 'room_id', 'apartment_id')
            ->withPivot('room_id', 'apartment_name');
}

         public function invoices()
        {
            return $this->hasMany(Invoice::class, 'room_id', 'id');
        }
        public function user()
{
    return $this->belongsTo(User::class);
}

// Room.php (Room model)
public function getStatusAttribute()
{
    $status = $this->attributes['status'];

    if ($status === 'occupied') {
        return 'Occupied';
    } elseif ($status === 'booked') {
        return 'Booked';
    } elseif ($status === 'available') {
        return 'Available';
    } else {
        return 'Unknown';
    }
}
public function bookedUser()
{
    return $this->belongsToMany(User::class, 'rooms_user')
        ->wherePivot('status', 'booked')
        ->withTimestamps();
}
public function watchlists()
{
    return $this->morphMany(Watchlist::class, 'watchable');
}
public function images()
    {
        return $this->hasMany(RoomImage::class, 'room_id');
    }
}
