<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Services extends Model
{
    use HasFactory;
   protected $fillable = ['id', 'subscription_date', 'next_billing_date','name', 'base_price', 'billing_cycle', 'bandwidth'];


public function apartments()
{
   return $this->belongsToMany(Apartments::class)->withPivot('id', 'subscription_date', 'next_billing_date');
}
public function watchlists()
{
    return $this->morphMany(Watchlist::class, 'watchable');
}
}
