<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Ticket extends Model
{
    use HasFactory;

    protected $fillable = [
        'message', // Add 'message' to the fillable attributes
        'user_id', // Add 'user_id' to the fillable attributes
        'status',
        'ticket_id',
        // Other fillable attributes, if any
    ];
    public function user()
{
    return $this->belongsTo(User::class);
}

public function responses()
{
    return $this->hasMany(TicketResponse::class);
}
// Define the "replies" relationship
public function replies()
{
    return $this->hasMany(TicketReply::class);
}
}
