<?php

namespace App\Models;

use App\Models\Rooms;
use App\Models\Invoice;
use App\Models\userTask;
use Laravel\Sanctum\HasApiTokens;
use Spatie\Permission\Models\Role;
use Illuminate\Notifications\Notifiable;
use Illuminate\Contracts\Auth\MustVerifyEmail;

use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Spatie\Permission\Traits\HasRoles; // Import the HasRoles trait

class User extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable;
    use Notifiable;
    use HasRoles;
    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'name',
        'first_name',
        'username',
        'last_name',
        'phone_number',
        'email',
        'password',
        'id_number',
        'status',
        'is_online',
        'avatar',
        'updated_at',
        'address1',
        'address2',
        'county',
        'country',
        'postal_code',
        'location',
        'industry',
        'education',
        'area',
        'profile_picture'

    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];

    /**
     * USer to room
     *
     * Many to many
     */
    public function rooms()
{
    return $this->belongsToMany(Rooms::class, 'rooms_user');
}
public function apartments()
{
    return $this->belongsToMany(Apartments::class, 'user_apartment','user_id', 'apartment_id')
    ->withPivot('role') // Include the pivot column
        ->withTimestamps();
}
// public function roless()
// {
//     return $this->belongsToMany(Role::class, 'user_apartment','role')
//         ->withPivot('apartment_id'); // Assuming you store the apartment ID in the pivot table
// }
public function invoices()
{
    return $this->hasMany(Invoice::class);
}


public function roles()
{
    return $this->belongsToMany(Role::class, 'role_user');
}
public function isAdmin()
{
    return $this->roles->contains('name', 'admin'); // Assuming your role field represents the user's role.
}
public function ownedApartments()
{
    return $this->belongsToMany(Apartments::class, 'user_apartment', 'user_id', 'apartment_id')
                ->wherePivot('role', 'landlord');
}
public function isLandlord()
{
    return $this->roles->contains('name', 'landlord'); // Assuming your role field represents the user's role.
}
public function isTenant()
{
    return $this->roles->contains('name', 'tenant'); // Assuming your role field represents the user's role.
}
public function isCaretaker()
{
    return $this->roles->contains('name','caretaker'); // Assuming your role field represents the user's role.
}
public function requests()
{
    return $this->hasMany(Request::class);
}
public function tasks()
    {
        return $this->hasMany(userTask::class, 'user_id');
    }

    public function licensePurchases()
    {
        return $this->hasMany(LicensePurchase::class);
    }

    public function hasUpgradableLicense()
    {
        // Assuming you have a 'license' relationship on the User model
        $userLicense = $this->license;

        // Check if the user has a license and the license type is not 'premium'
        return $userLicense && $userLicense->type !== 'premium';
    }
    public function services()
    {
        return $this->belongsToMany(Service::class, 'user_service')->using(UserService::class)->withPivot(['amount', 'billing_cycle', 'signup_date', 'next_due_date', 'status']);
    }
    public function watchlist()
    {
        return $this->hasMany(Watchlist::class);
    }

    public function licensesInvoices()
    {
        return $this->hasMany(LicensesInvoice::class);
    }
}
