<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class VaryingExpense extends Model
{
    use HasFactory;
    protected $fillable = ['amount', 'description', 'expense_date', 'user_id'];

    // Define Many-to-One Relationship with Apartment
    public function apartment()
    {
        return $this->belongsTo(Apartments::class, 'apartment_id');
    }

    // Define Many-to-One Relationship with User
    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
