<?php

namespace App\Providers;

use App\Models\User;
use App\Models\Admin;
use App\Models\Landlord;
use App\Models\Caretaker;
use App\Models\Apartments;
use App\Policies\UserPolicy;
use App\Policies\AdminPolicy;
use App\Policies\LandlordPolicy;
use App\Policies\ModelPolicy\ApartmentPolicy;
use App\Policies\CaretakerPolicy;
use Illuminate\Support\Facades\Gate;
use Illuminate\Foundation\Support\Providers\AuthServiceProvider as ServiceProvider;

class AuthServiceProvider extends ServiceProvider
{
    /**
     * The policy mappings for the application.
     *
     * @var array<class-string, class-string>
     */
    protected $policies = [
        // 'App\Models\Model' => 'App\Policies\ModelPolicy',
        User::class => UserPolicy::class,
        Landlord::class => LandlordPolicy::class,
        Admin::class => AdminPolicy::class,
        Caretaker::class => CaretakerPolicy::class,
        Apartments::class => ApartmentPolicy::class,
    ];

    /**
     * Register any authentication / authorization services.
     *
     * @return void
     */
    public function boot()
    {
        $this->registerPolicies();

        //
    }

}
