<?php

namespace App\Services;

use App\Models\Invoice;
use App\Models\Payment;

class PaymentService
{
    public function recordPayment($userId, $invoiceId, $amountPaid)
    {
        // Your payment record creation code goes here.


        // Create a new payment record.
        $payment = new Payment();
        $payment->user_id = $userId; // Set the user ID for the payment.
        $payment->invoice_id = $invoiceId; // Set the invoice ID for the payment.
        $payment->amount_paid = $amountPaid; // Set the payment amount.
        $payment->payment_date = now(); // Set the payment date to the current date and time.
        $payment->save();

    }


    public function updatePayment($userId, $invoiceId, $amountPaid)
    {


        // Get the invoice for which the payment is made.
        $invoice = Invoice::find($invoiceId);

        // Calculate the total amount paid for the invoice.
        $totalPaid = Payment::where('invoice_id', $invoiceId)->sum('amount_paid');

        // Update the amount_paid field in the invoice.
        $invoice->amount_paid = $totalPaid;
        $invoice->save();

    }

}
