<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateUserServiceTable extends Migration
{
    public function up()
    {
        Schema::create('user_service', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('user_id');
            $table->unsignedBigInteger('service_id');
            $table->decimal('amount', 10, 2); // Assuming amount is decimal
            $table->string('billing_cycle');
            $table->timestamp('signup_date')->nullable();
            $table->timestamp('next_due_date')->nullable();
            $table->string('status')->nullable();
            // Add other necessary columns

            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
            $table->foreign('service_id')->references('id')->on('services')->onDelete('cascade');
        });
    }

    public function down()
    {
        Schema::dropIfExists('user_service');
    }
}
