<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateVaryingExpensesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        // Create Varying Expenses Table
Schema::create('varying_expenses', function (Blueprint $table) {
    $table->id();
    $table->unsignedBigInteger('apartment_id');
    $table->decimal('amount', 10, 2);
    $table->string('description');
    $table->date('expense_date');
    $table->unsignedBigInteger('user_id')->nullable(); // Nullable if the expense is not associated with a user
    // Add any other varying expense-related fields as needed
    $table->timestamps();

    // Define Foreign Key Relationships
    $table->foreign('apartment_id')->references('id')->on('apartments')->onDelete('cascade');
    $table->foreign('user_id')->references('id')->on('users')->onDelete('set null');
});
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('varying_expenses');
    }
}
