<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateFixedExpensesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
       // Create Fixed Expenses Table
Schema::create('fixed_expenses', function (Blueprint $table) {
    $table->id();
    $table->unsignedBigInteger('apartment_id');
    $table->decimal('amount', 10, 2);
    $table->enum('frequency', ['monthly', 'yearly', 'daily']);
    $table->date('start_date');
    // Add any other fixed expense-related fields as needed
    $table->timestamps();

    // Define Foreign Key Relationship
    $table->foreign('apartment_id')->references('id')->on('apartments')->onDelete('cascade');
});

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('fixed_expenses');
    }
}
