<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddProfileFieldsToUsers extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('users', function (Blueprint $table) {
            //
            $table->string('address')->nullable();
            $table->string('county')->nullable();
            $table->string('location')->nullable();
            $table->string('industry')->nullable();
            $table->string('education')->nullable();
            $table->string('area')->nullable();
            $table->string('phone_number')->nullable();
            $table->string('id_number')->nullable();
            $table->string('secondary_telephone')->nullable();
            $table->string('profile_picture')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('users', function (Blueprint $table) {
            //
            $table->dropColumn('address');
            $table->dropColumn('county');
            $table->dropColumn('industry');
            $table->dropColumn('education');
            $table->dropColumn('area');
            $table->dropColumn('phone_numnber');
            $table->dropColumn('id_number');
            $table->dropColumn('secondary_telephone');
            $table->dropColumn('profile_picture');
        });
    }
}
