@extends('admin.layouts.admin-layout')

@section('content')
<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <div class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1 class="m-0">APARTMENTS</h1>
          </div><!-- /.col -->
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="{{ route('admin.home') }}">Home</a></li>
              <li class="breadcrumb-item active">Dashboard v1</li>
            </ol>
          </div><!-- /.col -->
        </div><!-- /.row -->
      </div><!-- /.container-fluid -->
    </div>
    <!-- /.content-header -->
    <section class="content">
        <div class="container-fluid">
        <!-- Small boxes (Stat box) -->
            <div class="row">
                            {{-- {!! Form::open(['route' => 'assign.landlord', 'method' => 'post']) !!}

                            <div class="form-group">
                                {{ Form::label('apartment_id', 'Select an Apartment') }}
                                {{ Form::select('apartment_id', $apartments, null, ['class' => 'form-control']) }}
                            </div>

                            <div class="form-group">
                                {{ Form::label('landlord_id', 'Assign a Landlord') }}
                                {{-- {{ Form::select('landlord_id', $landlords, null, ['class' => 'form-control']) }} --}}
                            {{-- </div>

                            {{ Form::submit('Assign Landlord', ['class' => 'btn btn-primary']) }}

                            {!! Form::close() !!} --}}
                            <div class="container">
                                @if (Session::has('success'))
                                <div class="alert alert-success">
                                    {{ Session::get('success') }}
                                </div>
                            @endif

                            @if ($errors->any())
                                <div class="alert alert-danger">
                                    <ul>
                                        @foreach ($errors->all() as $error)
                                            <li>{{ $error }}</li>
                                        @endforeach
                                    </ul>
                                </div>
                            @endif
                                <h5><strong> Assign Landlord to Apartment</strong></h5>
                                <form method="POST" action="{{ route('assign.landlord') }}">
                                    @csrf

                                    {{-- <!-- Dropdown for selecting a user with the "landlord" role -->
                                    <div class="form-group">
                                        <label for="user_id">Select Landlord:</label>
                                        <select name="user_id" id="user_id" class="form-control">
                                            @foreach ($landlords as $user)
                                                <option value="{{ $user->id }}">{{ $user->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>

                                    <!-- Dropdown for selecting an apartment -->
                                    <div class="form-group">
                                        <label for="apartment_id">Select Apartment:</label>
                                        <select name="apartment_id" id="apartment_id" class="form-control">
                                            @foreach ($apartments as $apartment)
                                                <option value="{{ $apartment->id }}">{{ $apartment->name }}</option>
                                            @endforeach
                                        </select>
                                    </div> --}}
                                    <label for="apartment_id">Select Apartment:</label>
                                    <select name="apartment_id" id="apartment_id">
                                        @foreach ($apartments as $apartment)
                                            <option value="{{ $apartment->id }}">{{ $apartment->name }}</option>
                                        @endforeach
                                    </select>

                                    <label for="landlord_id">Select Landlord (User with Landlord Role):</label>
                                    <select name="landlord_id" id="landlord_id">
                                        @foreach ($landlords as $landlord)
                                            <option value="{{ $landlord->id }}">{{ $landlord->name }}</option>
                                        @endforeach
                                    </select>

                                    <!-- Assign button -->
                                    <button type="submit" class="btn btn-primary">Assign Landlord</button>
                                </form>
                            </div>


                        </div>
                    <section class="mb-5 p-7">
                    <div class="row">
                        <table>
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>Name</th>
                                    <th>Location</th>
                                    <th>Price</th>
                                    <th>Capacity</th>
                                    <th>Landlord</th>
                                    <th>Caretaker</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($apartments as $apartment)
                                    <tr>
                                        <td>{{ $apartment->id }}</td>
                                        <td>{{ $apartment->name }}</td>
                                        <td>{{ $apartment->location }}</td>
                                        <td>{{ $apartment->price }}</td>
                                        <td>{{ $apartment->capacity }}</td>
                                        <td>
                                            @if ($apartment->landlords)
                                            @foreach($apartment->landlords as $landlord)
                                                {{ $landlord->name }} ({{ $landlord->roles->implode('name', ', ') }})<br>
                                            @endforeach
                                        @else
                                            No landlords assigned
                                        @endif
                                    </td>
                                    <td>
                                        @if ($apartment->caretakers)
                                            @foreach($apartment->caretakers as $caretaker)
                                                {{ $caretaker->name }} ({{ $caretaker->roles->implode('name', ', ') }})<br>
                                            @endforeach
                                        @else
                                            No caretakers assigned
                                        @endif
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    </section>

                </div>
                </div></div>




@endsection
