<!-- resources/views/apartments/attach-template.blade.php -->
@extends('admin.layouts.admin-layout')

@section('content')
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <div class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1 class="m-0">Email Templates</h1>
          </div><!-- /.col -->
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="{{ route('admin.home') }}">Home</a></li>
              <li class="breadcrumb-item active">Dashboard v1</li>
            </ol>
          </div><!-- /.col -->
        </div><!-- /.row -->
      </div><!-- /.container-fluid -->
    </div>
    <!-- /.content-header -->
    @if (session('success'))
    <div class="alert alert-success">
        {{ session('success') }}
    </div>
@endif
    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">

        <h1>Attach Email Templates to Apartment: {{ $apartment->name }}</h1>
        <form action="{{ route('apartments.attach-template', $apartment) }}" method="POST">
            @csrf
            <div class="form-group">
                <label for="templates">Select Email Templates:</label>
                <select name="templates[]" id="templates" class="form-control" multiple>
                    @foreach ($templates as $template)
                        <option value="{{ $template->id }}">{{ $template->name }}</option>
                    @endforeach
                </select>
            </div>
            <button type="submit" class="btn btn-primary">Attach Templates</button>
        </form>
    </div>
@endsection
