<!-- resources/views/apartments/attach-template.blade.php -->
@extends('admin.layouts.admin-layout')

@section('content')
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <div class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1 class="m-0">Attach Email Templates to Apartments</h1>
          </div><!-- /.col -->
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="{{ route('admin.home') }}">Home</a></li>
              <li class="breadcrumb-item active">Dashboard v1</li>
            </ol>
          </div><!-- /.col -->
        </div><!-- /.row -->
      </div><!-- /.container-fluid -->
    </div>
    <!-- /.content-header -->
    @include('partials._message_box')

    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">
         <!-- Select Templates with Checklist -->
         <div class="form-group">
            <label>Select Template(s):</label>
            <div>
                <input type="checkbox" id="selectAllTemplates"> Select All<br>
                @foreach ($templates as $template)
                    <div class="form-check">
                        <input type="checkbox" name="templates[]" value="{{ $template->id }}" class="form-check-input templateCheckbox">
                        <label class="form-check-label">{{ $template->name }}</label>
                    </div>
                @endforeach
            </div>
        </div>

        <!-- Attach Button to Show Modal -->
        <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#apartmentsModal">Select Apartments</button>

        <!-- Modal for Selecting Apartments -->
        <div class="modal fade" id="apartmentsModal" tabindex="-1" role="dialog" aria-labelledby="apartmentsModalLabel" aria-hidden="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="apartmentsModalLabel">Select Apartments</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <!-- Search Bar -->
                        <input type="text" id="searchApartments" class="form-control mb-2" placeholder="Search Apartments">
                        <!-- Select All Apartments -->
                        <div class="form-check">
                            <input type="checkbox" id="selectAllApartments"> Select All
                        </div>
                        <!-- List of Apartments -->
                        @foreach ($apartments as $apartment)
                            <div class="form-check">
                                <input type="checkbox" name="apartments[]" value="{{ $apartment->id }}" class="form-check-input apartmentCheckbox">
                                <label class="form-check-label">{{ $apartment->name }}</label>
                            </div>
                        @endforeach
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                        <button type="button" class="btn btn-primary" id="attachTemplatesBtn">Attach Templates</button>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        // Select all templates checkbox logic
        document.getElementById('selectAllTemplates').addEventListener('change', function() {
            let checkboxes = document.querySelectorAll('.templateCheckbox');
            checkboxes.forEach(checkbox => {
                checkbox.checked = this.checked;
            });
        });

        // Select all apartments checkbox logic
        document.getElementById('selectAllApartments').addEventListener('change', function() {
            let checkboxes = document.querySelectorAll('.apartmentCheckbox');
            checkboxes.forEach(checkbox => {
                checkbox.checked = this.checked;
            });
        });

        // Attach button logic
        document.getElementById('attachTemplatesBtn').addEventListener('click', function() {
        let selectedTemplates = Array.from(document.querySelectorAll('.templateCheckbox:checked')).map(checkbox => checkbox.value);
        let selectedApartments = Array.from(document.querySelectorAll('.apartmentCheckbox:checked')).map(checkbox => checkbox.value);

        // Create a form
        let form = document.createElement('form');
        form.action = "{{ route('apartments.attach-template') }}";
        form.method = 'POST';
        form.style.display = 'none';

        // Add CSRF token
        let csrfToken = document.createElement('input');
        csrfToken.type = 'hidden';
        csrfToken.name = '_token';
        csrfToken.value = "{{ csrf_token() }}";
        form.appendChild(csrfToken);

        // Add selected templates
        selectedTemplates.forEach(templateId => {
            let input = document.createElement('input');
            input.type = 'hidden';
            input.name = 'templates[]';
            input.value = templateId;
            form.appendChild(input);
        });

        // Add selected apartments
        selectedApartments.forEach(apartmentId => {
            let input = document.createElement('input');
            input.type = 'hidden';
            input.name = 'apartments[]';
            input.value = apartmentId;
            form.appendChild(input);
        });

        // Append the form to the body and submit it
        document.body.appendChild(form);
        form.submit();

            // Close modal after attaching templates (if necessary)
            $('#apartmentsModal').modal('hide');
        });

        // Script for filtering apartments
        $('#searchApartments').on('input', function() {
            let filter = this.value.toUpperCase();
            let apartments = document.querySelectorAll('.form-check');
            apartments.forEach(apartment => {
                let name = apartment.querySelector('.form-check-label').textContent.toUpperCase();
                apartment.style.display = name.includes(filter) ? '' : 'none';
            });
        });
    </script>
@endsection
