@extends('admin.layouts.admin-layout')
<link rel="stylesheet" href="{{ asset('css/invoices.css') }}">
<style>
    /* Style for the container */
    .container-box {
        display: flex; /* Use flexbox to create a row layout */
        flex-direction: column; /* Stack boxes vertically */
        justify-content: space-between; /* Space between the two boxes */
        align-items: center; /* Center items horizontally within the container */
        width: 100%;
    }

    /* Style for the left and right boxes */
    .box {
        flex: 1; /* Equal width for both boxes */
        padding: 10px;
        text-align: center;
    }

    /* Add some styles for aesthetics */
    .box:nth-child(odd) {
        background-color: #f0f0f0;
    }

    .box:nth-child(even) {
        background-color: #e0e0e0;
    }
    /* Style for the table */
    table {
            width: 100%; /* Make the table width 100% of its container */
            border-collapse: collapse; /* Collapse borders for a clean look */
        }

        /* Style for table headers */
        th {
            background-color: #134f88; /* Header background color */
            color: #b7babd; /* Header text color */
            padding: 10px; /* Padding for header cells */
            text-align: left; /* Align header text to the left */
            padding: 10px; /* Adjust the padding as needed */
            border: 1px solid #ccc; /* Add borders for better visibility */
        }

        /* Add spacing between th elements */
        th + th {
            padding-left: 20px; /* Adjust spacing between th elements */
        }

        /* Style for table rows */
        tr {
            width: 100%; /* Set the row width to 100% */
        }

        /* Style for alternating row backgrounds */
        tr:nth-child(even) {
            background-color: #f2f2f2; /* Even row background color */
        }

        /* Style for table data cells */
        td {
            padding: 10px; /* Padding for data cells */
            border: 1px solid #ccc; /* Add border to data cells */
        }
</style>

@section('content')
            <div class="content-wrapper">
                <!-- Content Header (Page header) -->
                    <div class="content-header">
                    <div class="container-fluid">
                        <div class="row mb-2">
                        <div class="col-sm-6">
                            <h1 class="m-0">{{$invoice->invoice_number}}</h1>
                            @if (session('success'))
                                <div class="alert alert-success">
                                    {{ session('success') }}
                                </div>
                            @endif
                            @if ($errors->any())
    <div class="alert alert-danger">
        <ul>
            @foreach ($errors->all() as $error)
                <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
@endif

                        </div><!-- /.col -->
                        <div class="col-sm-6">
                            <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{ route('admin.home') }}">Home</a></li>
                            <li class="breadcrumb-item active">Dashboard v1</li>
                            </ol>
                        </div><!-- /.col -->
                        </div><!-- /.row -->
                    </div><!-- /.container-fluid -->
                    </div>
                <!-- /.content-header -->
                <!-- invoice-header -->

                <div class="container-fluid">
                    <div class="row " >
                        <div class="col box">
                        <!-- Left Item -->


                            <!-- Button to open the Add Payment modal -->
                            <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#addPaymentModal">
                                Add Payment
                            </button>
                            <div class="name-date-box">
                                <span class="label inline">Client Name:</span>
                                <span class="content inline inner-box">{{ $user->surname . $user->last_name }} <a>(View Invoices)</a></span>
                                <br> <!-- Add a line break to separate Name and Date -->
                                <span class="label inline"> Invoice Date:</span>
                                <span class="content inline inner-box">{{ $invoice->created_at}}</span>
                                <br>
                                <span class="label inline"> Due Date:</span>
                                <span class="content inline inner-box">{{ $invoice->due_date}}</span>
                                <br>
                                <span class="label inline">Total Amount:</span>
                                <span class="content inline inner-box">{{ $invoice->total_amount }}</span>
                                <br>
                                <span class="label inline">Amount Paid:</span>
                                <span class="content inline inner-box">{{ $invoice->amount_paid }}</span>
                                <br>
                                <span class="label inline">Date:</span>
                                <span class="content inline inner-box">September 15, 2023</span>
                                <br>
                                <span class="label inline">Balance:</span>
                                <span class="content inline inner-box">{{  $invoice->total_amount - $invoice->amount_paid}}</span>




                            </div>
                        </div>



                        <!-- Right Item -->
                        <div class="col box">
                        <div class="item-box box">
                            <div class="name-date-box">
                                <span class="label inline"></span>
                                <span class="content inline"><h1>{{ $invoice->payment_status}}</h1></span>
                                <br> <!-- Add a line break to separate Name and Date -->
                                <span class="label inline">Date:</span>
                                <span class="content inline">{{ $invoice->updated_at}}</span><br>
                                <span class="label inline">Payment Method:</span>
                                <span class="content inline">{{ $invoice->payment_method}}</span><br>
                                <!-- Buttons for marking invoices -->
                                <form action="{{ route('invoice.markStatus', ['invoice' => $invoice->id]) }}" method="POST">
                                    @csrf

                                    <!-- Mark as Paid Button -->
                                    <button type="submit" name="status" value="paid" class="btn btn-success">Mark as Paid</button>

                                    <!-- Mark as Unpaid Button -->
                                    <button type="submit" name="status" value="unpaid" class="btn btn-warning">Mark as Unpaid</button>

                                    <!-- Cancel Invoice Button -->
                                    <button type="submit" name="status" value="canceled" class="btn btn-danger">Cancel Invoice</button>
                                    <button type="submit" name="status" value="Partial">Mark as Partial</button>
                                </form>
                            </div>
                        </div>


                    </div>
                    </div>
                </div>



            <!--Invoice items-->
            <div class="container-fluid">
                <div class="row">
                    <div class="col">
                        <h2>Invoice Items</h2>
                        <form method="POST" action="{{ route('invoices.update', $invoice->id) }}">
    @csrf
    @method('PATCH')
    <table class="table">
        <thead>
            <tr>
                <th>Invoice Item</th>
                <th>Total Amount</th>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td>
                    <textarea name="invoice_items" class="form-control" rows="4" cols="50">
                        @if ($invoice->invoice_items)
                            @foreach (json_decode($invoice->invoice_items, true) as $item)
                                {{ $item['item'] }}: {{ $item['value'] }}
                            @endforeach
                        @endif
                    </textarea>
                </td>
                <td>
                    <input type="text" name="total_amount" value="{{ $invoice->total_amount }}" />
                </td>
            </tr>
        </tbody>
    </table>
    <button type="submit">Save Changes</button>
    <button type="button" class="btn btn-secondary" id="cancelChanges">Cancel Changes</button>
</form>

                        @if (session('success'))
                            <div class="alert alert-success">
                                {{ session('success') }}
                            </div>
                        @endif
                    </div>
                </div>
            </div>


            <!--/Invoice items--->
            <!-- Transactions items -->
<!-- Transactions items -->
<!-- Transactions items -->
<div class="container-fluid">
    <div class="row">
        <div class="col">
            <h2>Transactions</h2>

            @if (!empty($invoice->payments) && is_array(json_decode($invoice->payments, true)))
                <table class="table">
                    <thead>
                        <tr>
                            <th>Date</th>
                            <th>Payment Method</th>
                            <th>Transaction ID</th>
                            <th>Amount</th>
                            <th>Transaction Fee</th>
                            <th><input type="checkbox" id="selectAll" onchange="toggleCheckboxes()"></th>
                            <th></th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach (json_decode($invoice->payments, true) as $transaction)
                        <tr>
                            <td>{{ $transaction['payment_date'] }}</td>
                            <td>{{ $transaction['payment_method'] }}</td>
                            <td>{{ $transaction['transaction_id'] }}</td>
                            <td>{{ $transaction['payment_amount'] }}</td>
                            <td>{{ $transaction['transaction_fee'] }}</td>
                            <td><input type="checkbox" class="transaction-checkbox" data-transaction-index="{{ $loop->index }}"></td>

                        </tr>
                        @endforeach
                    </tbody>
                </table>
            @else
                <p>No transactions available.</p>
            @endif
        </div>
    </div>
    <button onclick="performAction()">Perform Action on Selected Items</button>
    <button onclick="deleteSelected()">Delete Selected Items</button>
</div>


            <!--/Transaction items--->
    </div><!--/Content Wrapper--->



<!-- Add Payment Modal -->
<div class="modal fade" id="addPaymentModal" tabindex="-1" role="dialog" aria-labelledby="addPaymentModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="addPaymentModalLabel">Add Payment</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div id="paymentResponseMessage"></div> <!-- Response message container -->
            <div class="modal-body">
                <form action="{{ route('invoice.addPayment', $invoice->id) }}" method="POST">
                    @csrf
                    <!-- Payment Date -->
                    <div class="form-group">
                        <label for="payment_date">Payment Date</label>
                        <input type="date" class="form-control" id="payment_date" name="payment_date">
                    </div>
                    <!-- Payment Method -->
                    <div class="form-group">
                        <label for="payment_method">Payment Method</label>
                        <input type="text" class="form-control" id="payment_method" name="payment_method">
                    </div>
                    <!-- Transaction ID -->
                    <div class="form-group">
                        <label for="transaction_id">Transaction ID</label>
                        <input type="text" class="form-control" id="transaction_id" name="transaction_id">
                    </div>
                    <!-- Amount -->
                    <div class="form-group">
                        <label for="amount">Amount</label>
                        <input type="text" class="form-control" id="payment_amount" name="payment_amount">
                    </div>
                    <!-- Transaction Fee -->
                    <div class="form-group">
                        <label for="transaction_fee">Transaction Fee</label>
                        <input type="text" class="form-control" id="transaction_fee" name="transaction_fee">
                    </div>
                    <button type="submit" class="btn btn-primary">Add Payment</button>
                </form>
            </div>
        </div>
    </div>
</div>





@endsection
<script>
    // Function to toggle all checkboxes
    function toggleCheckboxes() {
        const checkboxes = document.querySelectorAll('.itemCheckbox');
        const selectAllCheckbox = document.getElementById('selectAll');
        checkboxes.forEach(checkbox => {
            checkbox.checked = selectAllCheckbox.checked;
        });
    }

    // Function to perform an action on selected items
    function performAction() {
        const checkboxes = document.querySelectorAll('.itemCheckbox:checked');
        if (checkboxes.length === 0) {
            alert('No items selected.');
        } else {
            alert('Performing action on selected items: ' + Array.from(checkboxes).map(checkbox => checkbox.parentElement.parentElement.querySelector('td:nth-child(2)').textContent).join(', '));
        }
    }

    // Function to delete selected items
    function deleteSelected() {
        const checkboxes = document.querySelectorAll('.itemCheckbox:checked');
        if (checkboxes.length === 0) {
            alert('No items selected for deletion.');
        } else {
            if (confirm('Are you sure you want to delete the selected items?')) {
                checkboxes.forEach(checkbox => {
                    checkbox.parentElement.parentElement.remove();
                });
                alert('Selected items deleted.');
            }
        }
    }

    function cancelForm(){
    document.addEventListener("DOMContentLoaded", function() {
        const cancelButton = document.getElementById("cancelChanges");
        const form = document.querySelector("form");

        cancelButton.addEventListener("click", function() {
            form.reset(); // Resets the form fields to their initial values
        });
    });
}
 // Function to update the response message
function updateResponseMessage(message, isError = false) {
        const responseMessageContainer = document.getElementById('paymentResponseMessage');
        responseMessageContainer.innerHTML = `<div class="alert ${isError ? 'alert-danger' : 'alert-success'}">${message}</div>`;
    }
    // Listen for the modal shown event and display the response message
    $('#addPaymentModal').on('shown.bs.modal', function () {
        const urlParams = new URLSearchParams(window.location.search);
        const successMessage = urlParams.get('success');
        if (successMessage) {
            updateResponseMessage(successMessage);
        }
    });
</script>
