
@extends('admin.layouts.admin-layout')
<link rel="stylesheet" href="{{ asset('css/invoices.css') }}">

@section('content')

    <!-- Content Wrapper. Contains page content -->
            <div class="content-wrapper">
                <!-- Content Header (Page header) -->
                    <div class="content-header">
                    <div class="container-fluid">
                        <div class="row mb-2">
                        <div class="col-sm-6">
                            <h1 class="m-0">Invoices</h1>
                        </div><!-- /.col -->
                        <div class="col-sm-6">
                            <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{ route('admin.home') }}">Home</a></li>
                            <li class="breadcrumb-item active">Dashboard v1</li>
                            </ol>
                        </div><!-- /.col -->
                        </div><!-- /.row -->
                    </div><!-- /.container-fluid -->
                    </div>
                <!-- /.content-header -->

            <!-- Main content -->
            <body>
              <!-- Search invoices -->

            <section class="content">
                <div class="container-fluid">
            <div>
                @if(session('success'))
    <div class="alert alert-success">
        {{ session('success') }}
    </div>
@endif
                <button id="toggleButton">Search Invoices</button>
                <div id="toggleFields" style="display: none;">
                    <form>
                    <div class="row">
                        <label>Invoice #</label>
                        <input type="text" id="field1" placeholder="Field 1">
                        <label>Description</label>
                    <input type="text" id="field2" placeholder="Field 2">
                    </div>
                    <div class="row">
                        <label>Invoice #</label>
                        <input type="text" id="field1" placeholder="Field 1">
                        <label>Invoice #</label>
                    <input type="text" id="field2" placeholder="Field 2">
                    </div>
                    <div class="row">
                        <label>Invoice #</label>
                        <input type="text" id="field1" placeholder="Field 1">
                        <label>Invoice #</label>
                    <input type="text" id="field2" placeholder="Field 2">
                    </div>

                    <div class="row">
                    <button>Search</button>
                    </div>
                    </form>
                </div>
            </div>
                </div>
            </section>




                  <!--Rooms Listing--->
                  <section class="content">
                    <div class="container-fluid">
                        <h1>Invoices</h1>
                            <!--Table--->


                            <table class="table">
                                <thead>
                                    <tr>
                                        <th>Select</th>
                                        <th>Invoice #</th>
                                        <th>Client Name</th>
                                        <th>Invoice Date</th>
                                        <th>Due Date</th>
                                        <th>Total</th>
                                        <th>Payment Method</th>
                                        <th><form action="{{ route('admin.invoices') }}" method="GET">
                                            <select name="status" onchange="this.form.submit()">
                                                <option value="all" {{ $paymentStatus === 'all' ? 'selected' : '' }}>All</option>
                                                <option value="Paid" {{ $paymentStatus === 'Paid' ? 'selected' : '' }}>Paid</option>
                                                <option value="Unpaid" {{ $paymentStatus === 'Unpaid' ? 'selected' : '' }}>Unpaid</option>
                                            </select>
                                        </form></th>
                                        <th>Edit</th>
                                        <th>Del</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($invoices as $invoice): ?>
                                        <tr>
                                            <td><input type="checkbox" class="invoice-checkbox" data-invoice-id="<?php echo $invoice->id; ?>"></td>
                                            <td>
                                                <a href="{{ route('edit-invoice', ['invoice' => $invoice->id]) }}">

                                                    <?php echo $invoice->invoice_number; ?>
                                                </a>
                                            </td>
                                            <td><?php echo $invoice->user->name; ?></td>
                                            <td><?php echo $invoice->created_at; ?></td>
                                            <td><?php echo $invoice->due_date; ?></td>
                                            <td><?php echo $invoice->total_amount; ?></td>
                                            <td>Mpesa</td>
                                            <td><?php echo $invoice->payment_status; ?></td>
                                        </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>

                            <button id="delete-selected">Delete Selected</button>

                    <!--End Table--->
                </div>
                <!-- /.row (main row) -->
                </section>


                </div>
                </section>
        </div>
@endsection
@section('scripts')
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
    $(document).ready(function () {
        $("#toggleButton").click(function () {
            $("#toggleFields").toggle();
        });
    });
</script>

    <script>
//delete invoices
document.addEventListener("DOMContentLoaded", function () {
    const deleteButton = document.getElementById("delete-selected");
    const checkboxes = document.querySelectorAll(".invoice-checkbox");
    const csrfToken = document.querySelector('meta[name="csrf-token"]').getAttribute('content');

    deleteButton.addEventListener("click", function () {
        const selectedInvoiceIds = [];

        checkboxes.forEach((checkbox) => {
            if (checkbox.checked) {
                selectedInvoiceIds.push(checkbox.getAttribute("data-invoice-id"));
            }
        });

        // Check if any invoices are selected
        if (selectedInvoiceIds.length === 0) {
            alert("No invoices selected for deletion.");
            return;
        }

        // Ask for confirmation before deleting
        if (confirm("Are you sure you want to delete selected invoices?")) {
            // AJAX request to delete selected invoices
            fetch('/admin/invoices/delete-invoices', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': csrfToken,
                },
                body: JSON.stringify({ selectedInvoiceIds: selectedInvoiceIds }),
            })
            .then(response => response.json())
            .then(data => {
                // Handle the response from the server
                if (data.status === 'success') {
                    // Refresh the page
                    location.reload();
                } else {
                    alert(data.message); // Display an error message
                }
            })
            .catch(error => {
                console.error('Error:', error);
            });
        }
    });
});

</script>
@endsection
